@echo off
setlocal enabledelayedexpansion

rem Check number of arguments
set argC=0
for %%x in (%*) do set /A argC+=1
if "%argC%" neq "1" (
    echo Usage: %0 config-folder
    echo.
    echo Example:
    echo # Use configuration folder "src\dispatcher", run validator and then test the configuration
    echo # generated by validator with httpd -t (from docker image^), dump processed dispatcher.any config
    echo %0 src\dispatcher
    exit /B 2
)

set configDir=%1
set scriptDir=%~dp0

if exist %configDir%\opt-in\USE_SOURCES_DIRECTLY (

    echo opt-in USE_SOURCES_DIRECTLY marker file detected

    if [%WARNING_MODE%] equ [] (
        set WARNING_MODE=strict
    )

    echo Phase 1: Dispatcher validator
    call !scriptDir!validator full -relaxed !configDir!

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 1 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 1 finished

    echo Phase 2: httpd -t validation in docker image
    call !scriptDir!docker_run.cmd !configDir! localhost:12345 test

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 2 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 2 finished

    echo Phase 3: Immutability check
    call !scriptDir!docker_immutability_check.cmd !configDir!

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 3 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 3 finished

    if [%ENABLE_VALIDATOR_CHECK_FLAG%] equ [true] (
        echo Phase 4: Endpoints check
        set sdkDir=!scriptDir!..\
        call !scriptDir!validator check -configFolder !configDir! -sdkFolder !sdkDir!

        if !ERRORLEVEL! NEQ 0 (
            echo Phase 4 failed
            exit /B !ERRORLEVEL!
        )

        echo Phase 4 finished
    )
) else (
    echo WARNING: legacy mode was detected. Please plan to move to flexible mode and benefit from all the new features. More details here https://experienceleague.adobe.com/docs/experience-manager-cloud-service/content/implementing/content-delivery/validation-debug.html?lang=en#migrating
    set randomSubstring=!RANDOM!
    set tempDir="!TEMP!\dispatcher_validation_!randomSubstring!"

    if exist "!tempDir!" (
        rmdir "!tempDir!" /s /q
    )

    mkdir "!tempDir!"

    echo Phase 1: Dispatcher validator
    call !scriptDir!validator full -d !tempDir! !configDir!

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 1 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 1 finished

    echo Phase 2: httpd -t validation in docker image
    set HTTPD_DUMP_VHOSTS=true
    call !scriptDir!docker_run.cmd !tempDir! localhost:12345 test

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 2 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 2 finished

    echo WARNING: legacy mode was detected. Please plan to move to flexible mode and benefit from all the new features. More details here https://experienceleague.adobe.com/docs/experience-manager-cloud-service/content/implementing/content-delivery/validation-debug.html?lang=en#migrating

    echo Phase 3: Immutability check
    call !scriptDir!docker_immutability_check.cmd !configDir!

    if !ERRORLEVEL! NEQ 0 (
        echo Phase 3 failed
        exit /B !ERRORLEVEL!
    )

    echo Phase 3 finished

    if exist "!tempDir!" (
        rmdir "!tempDir!" /s /q
    )
)
