/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl.tasks;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.sling.installer.api.tasks.InstallationContext;
import org.apache.sling.installer.core.impl.tasks.AbstractBundleTask;
import org.apache.sling.installer.core.impl.tasks.TaskSupport;
import org.osgi.framework.Bundle;

public class RefreshBundlesTask
extends AbstractBundleTask {
    private static final String REFRESH_PACKAGES_ORDER = "60-";
    private static final Set<Long> BUNDLE_IDS = new HashSet<Long>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void markBundleForRefresh(InstallationContext ctx, TaskSupport btc, Bundle bundle) {
        Set<Long> set = BUNDLE_IDS;
        synchronized (set) {
            BUNDLE_IDS.add(bundle.getBundleId());
            ctx.addTaskToCurrentCycle(new RefreshBundlesTask(btc));
        }
    }

    public RefreshBundlesTask(TaskSupport btc) {
        super(null, btc);
    }

    @Override
    public String getSortKey() {
        return REFRESH_PACKAGES_ORDER;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(InstallationContext ctx) {
        boolean doFullRefresh = false;
        ArrayList<Bundle> bundles = new ArrayList<Bundle>();
        Set<Long> set = BUNDLE_IDS;
        synchronized (set) {
            for (Long id : BUNDLE_IDS) {
                Bundle b = this.getBundleContext().getBundle(id);
                if (b != null) {
                    this.getLogger().debug("Will refresh bundle {}", (Object)b);
                    bundles.add(b);
                    continue;
                }
                this.getLogger().debug("Bundle {} is already gone. Full refresh", (Object)id);
                doFullRefresh = true;
            }
            BUNDLE_IDS.clear();
        }
        if (doFullRefresh || bundles.size() > 0) {
            if (!this.getBundleRefresher().isInstallerBundleAffected(bundles)) {
                this.getBundleRefresher().refreshBundles(ctx, doFullRefresh ? null : bundles, true);
            } else {
                ctx.log("Installer bundle is affected by bundle refresh, initiating asynchronous refresh", new Object[0]);
                ctx.addTaskToCurrentCycle(new AsyncRefreshBundlesTask(this.getTaskSupport(), doFullRefresh ? null : bundles));
            }
        }
    }

    private final class AsyncRefreshBundlesTask
    extends AbstractBundleTask {
        private final List<Bundle> bundles;

        public AsyncRefreshBundlesTask(TaskSupport btc, List<Bundle> bundles) {
            super(null, btc);
            this.bundles = bundles;
        }

        @Override
        public void execute(InstallationContext ctx) {
            this.getBundleRefresher().refreshBundles(ctx, this.bundles, false);
        }

        @Override
        public String getSortKey() {
            return "07-";
        }

        @Override
        public boolean isAsynchronousTask() {
            return true;
        }
    }
}

