/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.CheckForNull;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.api.tasks.TaskResource;
import org.apache.sling.installer.api.tasks.TransformationResult;
import org.apache.sling.installer.core.impl.FileDataStore;
import org.apache.sling.installer.core.impl.InternalResource;
import org.apache.sling.installer.core.impl.Util;
import org.osgi.framework.Version;

public class RegisteredResourceImpl
implements TaskResource,
Serializable,
Comparable<RegisteredResourceImpl> {
    private static final long serialVersionUID = 6L;
    private static final int VERSION = 4;
    private String url;
    private String urlScheme;
    private String digest;
    private String entity;
    private final Dictionary<String, Object> dictionary;
    private final Map<String, Object> attributes = new HashMap<String, Object>();
    private String dataUri;
    private File dataFile;
    private int priority;
    private String resourceType;
    private ResourceState state = ResourceState.INSTALL;
    private transient Map<String, Object> temporaryAttributes;
    private boolean cleanedUp = false;
    private long lastChange = -1L;
    private String error;

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeInt(4);
        out.writeObject(this.url);
        out.writeObject(this.urlScheme);
        out.writeObject(this.digest);
        out.writeObject(this.entity);
        out.writeObject(this.dictionary);
        out.writeObject(this.attributes);
        out.writeObject(this.dataFile);
        out.writeObject(this.resourceType);
        out.writeInt(this.priority);
        out.writeObject(this.state.toString());
        out.writeLong(this.lastChange);
        out.writeObject(this.dataUri);
        out.writeObject(this.error);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        String updatedDigest;
        int version = in.readInt();
        if (version < 1 || version > 4) {
            throw new ClassNotFoundException(this.getClass().getName());
        }
        Util.setField(this, "url", in.readObject());
        Util.setField(this, "urlScheme", in.readObject());
        Util.setField(this, "digest", in.readObject());
        Util.setField(this, "entity", in.readObject());
        Util.setField(this, "dictionary", in.readObject());
        Util.setField(this, "attributes", in.readObject());
        Util.setField(this, "dataFile", in.readObject());
        Util.setField(this, "resourceType", in.readObject());
        Util.setField(this, "priority", in.readInt());
        this.state = ResourceState.valueOf((String)in.readObject());
        this.lastChange = version > 1 ? in.readLong() : 0L;
        if (version > 2) {
            this.dataUri = (String)in.readObject();
        } else if ("config".equals(this.resourceType) && this.dictionary != null && !(updatedDigest = FileDataStore.computeDigest(this.dictionary)).equals(this.digest)) {
            this.digest = updatedDigest;
        }
        this.error = version > 3 ? (String)in.readObject() : "";
        if (this.dataFile != null) {
            this.dataFile = FileDataStore.SHARED.getDataFile(this.dataFile.getName());
        }
    }

    public static RegisteredResourceImpl create(InternalResource input) throws IOException {
        int schemePos = input.getURL().indexOf(58);
        return new RegisteredResourceImpl(input.getId(), input.getResourceUri(), input.getPrivateCopyOfFile(), input.getPrivateCopyOfDictionary(), input.getType(), input.getDigest(), input.getPriority(), input.getURL().substring(0, schemePos));
    }

    private RegisteredResourceImpl(String id, String resourceUri, File file, Dictionary<String, Object> dict, String type, String digest, int priority, String scheme) {
        this.url = scheme + ':' + id;
        this.dataUri = resourceUri;
        this.dataFile = file;
        this.dictionary = dict;
        this.resourceType = type;
        this.digest = digest;
        this.priority = priority;
        this.urlScheme = scheme;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (this.getEntityId() == null) {
            sb.append("RegisteredResource");
        } else {
            sb.append("TaskResource");
        }
        sb.append("(url=");
        sb.append(this.getURL());
        if (this.getEntityId() != null) {
            sb.append(", entity=");
            sb.append(this.getEntityId());
            sb.append(", state=");
            sb.append((Object)this.state);
            if (this.attributes.size() > 0) {
                sb.append(", attributes=[");
                boolean first = true;
                for (Map.Entry<String, Object> entry : this.attributes.entrySet()) {
                    if (!first) {
                        sb.append(", ");
                    }
                    first = false;
                    sb.append(entry.getKey());
                    sb.append("=");
                    sb.append(entry.getValue());
                }
                sb.append("]");
            }
        }
        sb.append(", digest=");
        sb.append(this.getDigest());
        sb.append(')');
        return sb.toString();
    }

    public boolean hasDataFile() {
        return this.dataFile != null;
    }

    public File getDataFile() {
        return this.dataFile;
    }

    private void removeDataFile() {
        if (this.dataFile != null && this.dataFile.exists()) {
            this.dataFile.delete();
        }
        this.dataUri = null;
    }

    public void cleanup() {
        if (!this.cleanedUp) {
            this.cleanedUp = true;
            this.removeDataFile();
            FileDataStore.SHARED.removeFromDigestCache(this.url, this.digest);
        }
    }

    @Override
    public String getURL() {
        return this.url;
    }

    @Override
    public InputStream getInputStream() throws IOException {
        if (this.dataUri != null) {
            try {
                URI uri = new URI(this.dataUri);
                return uri.toURL().openStream();
            }
            catch (URISyntaxException use) {
                throw (IOException)new IOException().initCause(use);
            }
        }
        if (this.dataFile != null && this.dataFile.exists()) {
            return new BufferedInputStream(new FileInputStream(this.dataFile));
        }
        return null;
    }

    @Override
    public Dictionary<String, Object> getDictionary() {
        return this.dictionary;
    }

    @Override
    public String getDigest() {
        return this.digest;
    }

    @Override
    public String getType() {
        return this.resourceType;
    }

    @Override
    public String getEntityId() {
        return this.entity;
    }

    @Override
    public Object getAttribute(String key) {
        return this.attributes.get(key);
    }

    @Override
    public void setAttribute(String key, Object value) {
        if (value == null) {
            this.attributes.remove(key);
        } else {
            this.attributes.put(key, value);
        }
    }

    @Override
    public String getScheme() {
        return this.urlScheme;
    }

    @Override
    public int getPriority() {
        return this.priority;
    }

    @Override
    public ResourceState getState() {
        return this.state;
    }

    public void setState(ResourceState s, String error) {
        this.lastChange = System.currentTimeMillis();
        this.state = s;
        this.error = error;
    }

    public long getLastChange() {
        return this.lastChange;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RegisteredResourceImpl)) {
            return false;
        }
        if (this.entity == null) {
            return this.getURL().equals(((RegisteredResourceImpl)obj).getURL());
        }
        return this.compareTo((RegisteredResourceImpl)obj) == 0;
    }

    public int hashCode() {
        return this.getURL().hashCode();
    }

    @Override
    public int compareTo(RegisteredResourceImpl b) {
        return RegisteredResourceImpl.compare(this, b);
    }

    public static boolean isSameResource(RegisteredResourceImpl a, RegisteredResourceImpl b) {
        Version va = a.getVersion();
        Version vb = b.getVersion();
        if (va != null && vb != null) {
            if (!vb.equals(va)) {
                return false;
            }
            boolean isSnapshot = va.toString().contains("SNAPSHOT");
            if (!isSnapshot) {
                return true;
            }
        }
        return a.getDigest().equals(b.getDigest());
    }

    public static int compare(TaskResource a, TaskResource b) {
        int result = 0;
        String aId = a.getEntityId();
        String bId = b.getEntityId();
        if (aId != null && bId != null) {
            result = aId.compareTo(bId);
        }
        boolean hasVersion = false;
        if (result == 0) {
            boolean isSnapshot = false;
            Version va = a.getVersion();
            Version vb = b.getVersion();
            if (va != null && vb != null) {
                hasVersion = true;
                isSnapshot = va.toString().contains("SNAPSHOT");
                result = vb.compareTo(va);
            }
            if (result == 0) {
                result = Integer.valueOf(b.getPriority()).compareTo(a.getPriority());
            }
            if (result == 0 && isSnapshot) {
                result = b.getDigest().compareTo(a.getDigest());
            }
        }
        if (result == 0 && a.getState() != b.getState()) {
            if (a.getState() == ResourceState.INSTALLED) {
                return -1;
            }
            if (b.getState() == ResourceState.INSTALLED) {
                return 1;
            }
            if (a.getState() == ResourceState.INSTALL) {
                return -1;
            }
            if (b.getState() == ResourceState.INSTALL) {
                return 1;
            }
        }
        if (result == 0 && (result = a.getURL().compareTo(b.getURL())) == 0 && !hasVersion) {
            result = b.getDigest().compareTo(a.getDigest());
        }
        return result;
    }

    @Override
    public Object getTemporaryAttribute(String key) {
        if (this.temporaryAttributes != null) {
            return this.temporaryAttributes.get(key);
        }
        return null;
    }

    @Override
    public void setTemporaryAttribute(String key, Object value) {
        if (this.temporaryAttributes == null) {
            this.temporaryAttributes = new HashMap<String, Object>();
        }
        if (value == null) {
            this.temporaryAttributes.remove(key);
        } else {
            this.temporaryAttributes.put(key, value);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void update(TransformationResult tr) throws IOException {
        InputStream is = tr.getInputStream();
        if (tr.getResourceType() != null) {
            this.resourceType = tr.getResourceType();
            if (tr.getId() != null) {
                this.entity = this.resourceType + ':' + tr.getId();
            } else if (!"file".equals(this.getType()) && !"properties".equals(this.getType())) {
                String lastIdPart = this.getURL();
                int slashPos = lastIdPart.lastIndexOf(47);
                if (slashPos != -1) {
                    lastIdPart = lastIdPart.substring(slashPos + 1);
                }
                this.entity = this.resourceType + ':' + lastIdPart;
            }
        }
        if (is != null) {
            try {
                File newDataFile = FileDataStore.SHARED.createNewDataFile(this.getType(), is);
                this.removeDataFile();
                this.dataFile = newDataFile;
            }
            finally {
                try {
                    is.close();
                }
                catch (IOException iOException) {}
            }
        }
        if (tr.getAttributes() != null) {
            this.attributes.putAll(tr.getAttributes());
        }
        if (tr.getVersion() != null) {
            this.attributes.put("Bundle-Version", tr.getVersion().toString());
        }
    }

    public void update(InternalResource rsrc) {
        if (rsrc.getResourceUri() != null) {
            FileDataStore.SHARED.removeFromDigestCache(this.url, this.digest);
            this.removeDataFile();
            this.dataUri = rsrc.getResourceUri();
            if (this.dictionary != null) {
                this.dictionary.put("resource.uri.hint", rsrc.getResourceUri());
            }
        } else if (rsrc.getPrivateCopyOfFile() != null) {
            boolean update;
            boolean bl = update = this.dataFile == null || !this.dataFile.getName().equals(rsrc.getPrivateCopyOfFile().getName());
            if (update) {
                if (this.dictionary != null) {
                    this.dictionary.remove("resource.uri.hint");
                }
                if (this.dataFile != null) {
                    this.removeDataFile();
                }
                this.dataFile = rsrc.getPrivateCopyOfFile();
                FileDataStore.SHARED.updateDigestCache(this.url, this.dataFile, this.digest);
            }
        }
    }

    public TaskResource clone(TransformationResult transformationResult) throws IOException {
        int schemePos = this.url.indexOf(58);
        RegisteredResourceImpl rr = new RegisteredResourceImpl(this.url.substring(schemePos + 1), this.dataUri, this.dataFile, this.dictionary, this.resourceType, this.digest, this.priority, this.urlScheme);
        rr.attributes.putAll(this.attributes);
        rr.update(transformationResult);
        return rr;
    }

    public void update(File file, Dictionary<String, Object> dict, String digest, int priority, String url) {
        this.removeDataFile();
        if (file != null) {
            this.dataFile = file;
        } else {
            while (!this.dictionary.isEmpty()) {
                this.dictionary.remove(this.dictionary.keys().nextElement());
            }
            Enumeration<String> keys = dict.keys();
            while (keys.hasMoreElements()) {
                String key = keys.nextElement();
                this.dictionary.put(key, dict.get(key));
            }
        }
        this.digest = digest;
        this.priority = priority;
        this.url = url;
        int pos = url.indexOf(58);
        this.urlScheme = url.substring(0, pos);
    }

    @Override
    public Version getVersion() {
        String vInfo = (String)this.getAttribute("Bundle-Version");
        return vInfo == null ? null : new Version(vInfo);
    }

    @Override
    @CheckForNull
    public String getError() {
        return this.error;
    }
}

