/*
 * Decompiled with CFR 0.152.
 */
package org.apache.sling.installer.core.impl;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Version;
import org.osgi.framework.VersionRange;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BundleBlackList {
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    public static final String BOOTSTRAP_FILENAME = "sling_bootstrap.txt";
    private static String UNINSTALL_PREFIX = "uninstall ";
    private Map<String, VersionRange> blacklistMap = new HashMap<String, VersionRange>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BundleBlackList(BundleContext bc) {
        BufferedReader r = null;
        try {
            String launchpadFolder = bc.getProperty("sling.launchpad");
            String filepath = launchpadFolder + File.separator + BOOTSTRAP_FILENAME;
            this.logger.debug("Parsing {} for uninstall directives to be used as blacklist", (Object)filepath);
            r = new BufferedReader(new FileReader(filepath));
            this.getBlackListFromBootstrapFile(r);
        }
        catch (IOException ignore) {
        }
        finally {
            if (r != null) {
                try {
                    r.close();
                }
                catch (IOException ignore) {}
            }
        }
    }

    private void getBlackListFromBootstrapFile(BufferedReader r) throws IOException {
        String line = null;
        while ((line = r.readLine()) != null) {
            line = line.trim();
            String bundleSymbolicName = null;
            VersionRange versionRange = null;
            if (line.length() <= 0 || !line.startsWith(UNINSTALL_PREFIX)) continue;
            String[] s = line.split(" ");
            this.extractBlackList(bundleSymbolicName, versionRange, s, 1, 2);
        }
    }

    public boolean isBlacklisted(String symbolicName, Version version) {
        if (this.blacklistMap.containsKey(symbolicName)) {
            VersionRange range = this.blacklistMap.get(symbolicName);
            return range == null || range.includes(version);
        }
        return false;
    }

    private void extractBlackList(String bundleSymbolicName, VersionRange versionRange, String[] s, int posSymbolicName, int posVersionRange) {
        if (s.length > posSymbolicName) {
            bundleSymbolicName = s[posSymbolicName].trim();
        }
        if (s.length > posVersionRange) {
            versionRange = new VersionRange(s[posVersionRange].trim());
        }
        this.blacklistMap.put(bundleSymbolicName, versionRange);
    }
}

