/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.upgrade;

import com.adobe.granite.quickstart.base.impl.Constants;
import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.Unpacker;
import com.adobe.granite.quickstart.base.impl.io.IOUtils;
import com.adobe.granite.quickstart.base.impl.ui.UserInterface;
import com.adobe.granite.quickstart.base.impl.upgrade.LogFileUpdater;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Dictionary;
import java.util.LinkedList;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.sling.installer.api.event.InstallationEvent;
import org.apache.sling.installer.api.event.InstallationListener;
import org.apache.sling.installer.api.tasks.ResourceState;
import org.apache.sling.installer.core.impl.EntityResourceList;
import org.apache.sling.installer.core.impl.FileDataStore;
import org.apache.sling.installer.core.impl.PersistentResourceList;
import org.apache.sling.installer.core.impl.RegisteredResourceImpl;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;
import org.osgi.framework.BundleListener;
import org.osgi.framework.Filter;
import org.osgi.framework.FrameworkListener;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceFactory;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceObjects;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtil {
    private static final String PROP_UPGRADE_MOVE_PREFIX = "upgrade.move.file.";
    private static final String PROP_UPGRADE_COPY_PREFIX = "upgrade.copy.file.";
    private static final String PROP_INSTALL_COPY_PREFIX = "install.copy.file.";
    private static final String PROP_UPGRADE_DELETE_PROPS = "upgrade.delete.properties";
    private static final String PROP_UPGRADE_DELETE = "upgrade.delete.files";
    private static final String PRESERVE_EXISTING_FILES_DIR = "upgrade-backup";
    private static final String ARCHIVED_VERSIONS_FOLDER = "archived-versions";
    private static final String PROP_UPGRADE_PRESERVE_FILES = "upgrade.preserve.existing.files";
    private static final String PROP_ARCHIVE_FOLDERS = "archive.folder.names";
    private static final String OLD_FILE_PATH = File.separatorChar + "quickstart.properties";
    private static final String NEW_FILE_PATH = File.separatorChar + "conf" + OLD_FILE_PATH;
    private Logger log = LoggerFactory.getLogger(UpgradeUtil.class);
    private final File installPropertiesFile;
    private final ProductProperties product;
    private final UserInterface ui;

    public UpgradeUtil(ProductProperties product, UserInterface ui) throws IOException {
        this.product = product;
        this.installPropertiesFile = new File(product.getSlingHomeDir().getAbsolutePath() + NEW_FILE_PATH);
        this.installPropertiesFile.getParentFile().mkdirs();
        this.ui = ui;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Mode handleInstallAndUpgrade(boolean unpackOnly) throws Exception {
        File preUpgradeHCStatus;
        Mode upgradeMode = this.getUpgradeMode();
        System.out.println("UpgradeUtil.handleInstallAndUpgrade has mode " + (Object)((Object)upgradeMode));
        if (upgradeMode == Mode.UPGRADE && (preUpgradeHCStatus = new File(this.product.getSlingHomeDir() + File.separator + "preUpgradeHCStatus.properties")).exists()) {
            Properties properties = new Properties();
            try (FileInputStream is = null;){
                is = new FileInputStream(preUpgradeHCStatus);
                properties.load(is);
                boolean areAllPreUpgradeHealthChecksOK = Boolean.parseBoolean(properties.getProperty("areAllPreUpgradeHealthChecksOK", "true"));
                if (!areAllPreUpgradeHealthChecksOK) {
                    System.err.println("The upgrade can not be started because the mandatory pre-upgrade health checks were not successful on the last run. Please rerun the pre-upgrade checks and start the upgrade process only if the health checks are successful. You can check the health check current status in this file: " + preUpgradeHCStatus.getAbsolutePath());
                    System.exit(4);
                }
            }
        }
        if (upgradeMode == Mode.INSTALL || upgradeMode == Mode.UPGRADE && !unpackOnly) {
            this.updatePropFile(upgradeMode == Mode.UPGRADE);
        }
        File backupDir = new File(this.product.getSlingHomeDir(), PRESERVE_EXISTING_FILES_DIR);
        this.restore(backupDir);
        if (upgradeMode == Mode.UPGRADE) {
            if (!unpackOnly) {
                this.cleanFIState();
                this.backup(backupDir);
                this.archivePreviousVersion();
            }
            LogFileUpdater.updateLogFiles(this.product, this.ui);
        }
        Unpacker unpacker = new Unpacker(this.product, this.ui);
        unpacker.unpack(upgradeMode);
        if (upgradeMode == Mode.UPGRADE) {
            this.restore(backupDir);
            unpacker.markExecutables();
        } else if (upgradeMode == Mode.INSTALL) {
            this.copyInstallFiles();
            unpacker.markExecutables();
        }
        return upgradeMode;
    }

    public void resetUpgradeMode() {
        this.installPropertiesFile.delete();
        new File(this.product.getSlingHomeDir().getAbsolutePath() + OLD_FILE_PATH).delete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Mode getUpgradeMode() throws IOException {
        File propsFile = this.installPropertiesFile;
        if (!propsFile.canRead() && !(propsFile = new File(this.product.getSlingHomeDir().getAbsolutePath() + OLD_FILE_PATH)).canRead()) {
            this.ui.debug(this.installPropertiesFile.getName() + " not found, initial install");
            return Mode.INSTALL;
        }
        Properties p = new Properties();
        try (FileInputStream is = null;){
            is = new FileInputStream(propsFile);
            p.load(is);
        }
        String oldBuildNumber = p.getProperty("quickstart.build");
        String currentBuildNumber = this.product.getBuildInfo();
        if (!currentBuildNumber.equals(oldBuildNumber)) {
            this.ui.debug("Build number changed, running in upgrade mode");
            return Mode.UPGRADE;
        }
        this.ui.debug("Build number not changed, software update not needed");
        return Mode.RESTART;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updatePropFile(boolean useTemp) throws IOException {
        File propFile = useTemp ? new File(this.installPropertiesFile.getAbsolutePath() + "_tmp") : this.installPropertiesFile;
        this.ui.debug("Saving build number in " + propFile.getName());
        Properties p = new Properties();
        p.setProperty("quickstart.build", this.product.getBuildInfo());
        FileOutputStream out = null;
        try {
            out = new FileOutputStream(propFile);
            p.store(out, "Created by " + this.getClass().getName() + " at " + new Date());
        }
        finally {
            if (out != null) {
                try {
                    ((OutputStream)out).close();
                }
                catch (IOException iOException) {}
            }
        }
        File oldPropsFile = new File(this.product.getSlingHomeDir().getAbsolutePath() + OLD_FILE_PATH);
        if (oldPropsFile.exists()) {
            this.ui.debug("Upgrade: deleting old properties file " + oldPropsFile);
            oldPropsFile.delete();
        }
    }

    private void archivePreviousVersion() throws Exception {
        String[] toArchive;
        this.ui.debug("Upgrade in progress, archiving previous software...");
        this.deleteUpgradeFiles();
        this.moveUpgradeFiles();
        File archiveBaseFolder = new File(new File(this.product.getSlingHomeDir(), ARCHIVED_VERSIONS_FOLDER), Constants.ARCHIVE_ID);
        LinkedList<String> noArchive = new LinkedList<String>();
        for (String str : this.product.getRequiredProperty("noarchive.folder.names").split(",")) {
            noArchive.add(str.trim());
        }
        noArchive.add(ARCHIVED_VERSIONS_FOLDER);
        noArchive.add(PRESERVE_EXISTING_FILES_DIR);
        String[] folders = this.product.getSlingHomeDir().list();
        if (folders != null) {
            for (String f : folders) {
                File folder = new File(this.product.getSlingHomeDir(), f);
                if (!folder.isDirectory()) continue;
                if (noArchive.contains(folder.getName())) {
                    this.ui.debug("Folder not archived due to noArchive list: " + folder.getAbsolutePath());
                    continue;
                }
                this.archiveWorkdirFolder(folder, archiveBaseFolder, folder.getName());
            }
        }
        for (String f : toArchive = this.product.getRequiredProperty(PROP_ARCHIVE_FOLDERS).split(",")) {
            File src = new File(this.product.getSlingHomeDir(), f.trim());
            if (!src.exists()) continue;
            this.archiveWorkdirFolder(src, archiveBaseFolder, f);
        }
        this.deletePropertiesFromSlingProperties();
    }

    private void archiveWorkdirFolder(File src, File archiveBaseFolder, String archivePath) throws IOException {
        File dest = new File(archiveBaseFolder, archivePath);
        dest.getParentFile().mkdirs();
        this.ui.debug("Archiving " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
        IOUtils.moveFile(src, dest);
    }

    private void tryToDelete(File f) throws IOException {
        if (f.exists()) {
            this.ui.debug("Upgrade in progress, deleting " + f.getAbsolutePath());
            this.deleteRecursively(f);
        }
        if (f.exists()) {
            this.ui.debug("Upgrade: Trying to delete " + f.getAbsolutePath());
            throw new IOException("Unable to delete " + f.getAbsolutePath());
        }
    }

    private void deleteUpgradeFiles() throws Exception {
        String str = this.product.getProperty(PROP_UPGRADE_DELETE);
        if (str != null) {
            for (String toDelete : str.split(",")) {
                String entry = toDelete.trim();
                if (entry.endsWith("*")) {
                    int lastSlash = entry.lastIndexOf(47);
                    String path = entry.substring(0, lastSlash);
                    File parent = new File(this.product.getSlingHomeDir(), path);
                    if (!parent.exists()) continue;
                    String name = entry.substring(lastSlash + 1, entry.length() - 1);
                    for (File child : parent.listFiles()) {
                        if (!child.getName().startsWith(name)) continue;
                        this.tryToDelete(child);
                    }
                    continue;
                }
                this.tryToDelete(new File(this.product.getSlingHomeDir(), entry));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void deletePropertiesFromSlingProperties() throws Exception {
        File slingPropsFile;
        String str = this.product.getProperty(PROP_UPGRADE_DELETE_PROPS);
        if (str != null && (slingPropsFile = this.product.getSlingPropertiesFile()).exists()) {
            this.ui.debug("Upgrading in progess, upgrading sling.properties");
            Properties slingProps = new Properties();
            FileInputStream is = null;
            try {
                is = new FileInputStream(slingPropsFile);
                slingProps.load(is);
            }
            finally {
                if (is != null) {
                    try {
                        ((InputStream)is).close();
                    }
                    catch (IOException iOException) {}
                }
            }
            ArrayList<Object> toBeRemoved = new ArrayList<Object>();
            for (String propName : str.split(",")) {
                if (propName.endsWith("*")) {
                    String pattern = propName.substring(0, propName.length() - 1);
                    for (Object name : slingProps.keySet()) {
                        if (!name.toString().startsWith(pattern)) continue;
                        toBeRemoved.add(name);
                    }
                    continue;
                }
                if (!slingProps.containsKey(propName)) continue;
                toBeRemoved.add(propName);
            }
            for (Object e : toBeRemoved) {
                this.ui.debug("Upgrade: Removing '" + e + "' from sling.properties.");
                slingProps.remove(e);
            }
            if (toBeRemoved.size() > 0) {
                FileOutputStream os = null;
                try {
                    os = new FileOutputStream(slingPropsFile);
                    slingProps.store(os, null);
                }
                finally {
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
        }
    }

    private void moveUpgradeFiles() throws IOException {
        String prefix = PROP_UPGRADE_MOVE_PREFIX;
        for (int i = 1; i <= 99; ++i) {
            String[] srcDest;
            String str = this.product.getProperty(PROP_UPGRADE_MOVE_PREFIX + i);
            if (str == null || (srcDest = str.trim().split(":")).length != 2) continue;
            File src = new File(this.product.getSlingHomeDir(), srcDest[0]);
            File dest = new File(this.product.getSlingHomeDir(), srcDest[1]);
            if (src.exists()) {
                if (dest.exists()) {
                    this.ui.debug("Cannot move file " + src.getAbsolutePath() + " to " + dest.getAbsolutePath() + ", destination already exists");
                    continue;
                }
                this.ui.debug("Upgrade in progress, moving file " + src.getAbsolutePath() + " to " + dest.getAbsolutePath());
                dest.getParentFile().mkdirs();
                IOUtils.moveFile(src, dest);
                if (dest.exists()) continue;
                this.ui.debug("Failed to move file to " + dest.getAbsolutePath());
                continue;
            }
            this.ui.debug("File not found, not moved: " + src.getAbsolutePath());
        }
    }

    private void deleteRecursively(File f) {
        if (f.isDirectory()) {
            for (String child : f.list()) {
                this.deleteRecursively(new File(f, child));
            }
        }
        f.delete();
    }

    private void copyInstallFiles() throws IOException {
        String prefix = PROP_INSTALL_COPY_PREFIX;
        for (int i = 1; i <= 99; ++i) {
            File dst;
            File src;
            String[] srcDest;
            String str = this.product.getProperty(PROP_INSTALL_COPY_PREFIX + i);
            if (str == null || (srcDest = str.trim().split(":")).length != 2 || !(src = new File(this.product.getSlingHomeDir(), srcDest[0])).exists() || (dst = new File(this.product.getSlingHomeDir(), srcDest[1])).exists()) continue;
            dst.getParentFile().mkdirs();
            FileUtils.copyFile(src, dst);
        }
    }

    private void backup(File backupDir) throws IOException {
        File f;
        String[] filesToPreserve = this.getFilesToPreserve();
        int count = 0;
        for (String path : filesToPreserve) {
            f = new File(this.product.getSlingHomeDir(), path);
            if (!f.exists()) continue;
            if (f.isDirectory()) {
                for (File entry : f.listFiles()) {
                    if (entry.isDirectory()) continue;
                    ++count;
                    String s = new File(new File(path), entry.getName()).getPath();
                    this.backup(backupDir, entry, s);
                }
                continue;
            }
            ++count;
            this.backup(backupDir, f, path);
        }
        String prefix = PROP_UPGRADE_COPY_PREFIX;
        for (int i = 1; i <= 99; ++i) {
            String[] srcDest;
            String str = this.product.getProperty(PROP_UPGRADE_COPY_PREFIX + i);
            if (str == null || (srcDest = str.trim().split(":")).length != 2 || !(f = new File(this.product.getSlingHomeDir(), srcDest[0])).exists()) continue;
            ++count;
            this.backup(backupDir, f, srcDest[1]);
        }
        if (count > 0) {
            this.ui.debug("Upgrade: " + count + " files backed up before upgrade, under " + backupDir.getName());
        } else {
            this.ui.debug("Upgrade: no files to backup before upgrade");
        }
    }

    private void backup(File backupDir, File f, String path) throws IOException {
        File target = new File(backupDir, path);
        if (target.exists()) {
            path = path + "." + System.currentTimeMillis();
            target = new File(backupDir, path);
            this.ui.debug("Upgrade: 1:1 backup file already exists, backing up file as " + path + " under " + backupDir.getName());
        } else {
            this.ui.debug("Upgrade: Backing up file " + path + " under " + backupDir.getName());
        }
        target.getParentFile().mkdirs();
        FileUtils.copyFile(f, target);
    }

    private void restore(File backupDir) throws IOException {
        int count = this.restoreFile(backupDir, backupDir);
        if (count > 0) {
            this.ui.debug("Upgrade: restored " + count + " files from pre-upgrade backup");
        } else {
            this.ui.debug("Upgrade: no files to restore from pre-upgrade backup");
        }
    }

    private int restoreFile(File backupDir, File f) throws IOException {
        int count = 0;
        if (f.isFile()) {
            String prefix = backupDir.getAbsolutePath();
            String relTarget = f.getAbsolutePath().substring(prefix.length() + File.pathSeparator.length());
            File target = new File(this.product.getSlingHomeDir(), relTarget);
            if (target.exists()) {
                this.ui.debug("Upgrade: Cannot restore file, target exists: " + relTarget);
            } else {
                target.getParentFile().mkdirs();
                IOUtils.moveFile(f, target);
                this.ui.debug("Upgrade: Restored file: " + relTarget);
                ++count;
            }
        } else {
            File[] list = f.listFiles();
            if (list != null) {
                for (File i : list) {
                    count += this.restoreFile(backupDir, i);
                }
            }
            if ((list = f.listFiles()) == null || list.length == 0) {
                f.delete();
            } else {
                this.ui.debug("Could not delete directory " + f + " because it still has " + list.length + " entries");
            }
        }
        return count;
    }

    private String[] getFilesToPreserve() {
        String[] filesToPreserve;
        String filesToPreserveStr = this.product.getProperty(PROP_UPGRADE_PRESERVE_FILES);
        if (filesToPreserveStr == null || filesToPreserveStr.trim().length() == 0) {
            filesToPreserve = new String[]{};
        } else {
            filesToPreserve = filesToPreserveStr.split(",");
            for (int i = 0; i < filesToPreserve.length; ++i) {
                filesToPreserve[i] = filesToPreserve[i].trim();
            }
        }
        return filesToPreserve;
    }

    private void cleanFIState() {
        String registeredResourceListPath = this.product.getSlingHomeDir().getAbsolutePath() + File.separatorChar + "launchpad" + File.separatorChar + "installer" + File.separatorChar + "RegisteredResourceList.ser";
        final File registeredResourceListFile = new File(registeredResourceListPath);
        if (!(registeredResourceListFile.exists() && registeredResourceListFile.isFile() && registeredResourceListFile.canRead())) {
            this.log.error("Unable to read the registered resource list file at " + registeredResourceListFile);
            return;
        }
        FileDataStore.SHARED = new FileDataStore(new BundleContext(){

            @Override
            public String getProperty(String key) {
                return registeredResourceListFile.getParentFile().getAbsolutePath();
            }

            @Override
            public boolean ungetService(ServiceReference<?> reference) {
                return false;
            }

            @Override
            public void removeServiceListener(ServiceListener listener) {
            }

            @Override
            public void removeFrameworkListener(FrameworkListener listener) {
            }

            @Override
            public void removeBundleListener(BundleListener listener) {
            }

            @Override
            public <S> ServiceRegistration<S> registerService(Class<S> clazz, S service, Dictionary<String, ?> properties) {
                return null;
            }

            @Override
            public ServiceRegistration<?> registerService(String clazz, Object service, Dictionary<String, ?> properties) {
                return null;
            }

            @Override
            public ServiceRegistration<?> registerService(String[] clazzes, Object service, Dictionary<String, ?> properties) {
                return null;
            }

            @Override
            public Bundle installBundle(String location, InputStream input) throws BundleException {
                return null;
            }

            @Override
            public Bundle installBundle(String location) throws BundleException {
                return null;
            }

            @Override
            public <S> Collection<ServiceReference<S>> getServiceReferences(Class<S> clazz, String filter) throws InvalidSyntaxException {
                return null;
            }

            @Override
            public ServiceReference<?>[] getServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                return null;
            }

            @Override
            public <S> ServiceReference<S> getServiceReference(Class<S> clazz) {
                return null;
            }

            @Override
            public ServiceReference<?> getServiceReference(String clazz) {
                return null;
            }

            @Override
            public <S> S getService(ServiceReference<S> reference) {
                return null;
            }

            @Override
            public File getDataFile(String filename) {
                return null;
            }

            @Override
            public Bundle[] getBundles() {
                return null;
            }

            @Override
            public Bundle getBundle(String location) {
                return null;
            }

            @Override
            public Bundle getBundle(long id) {
                return null;
            }

            @Override
            public Bundle getBundle() {
                return null;
            }

            @Override
            public ServiceReference<?>[] getAllServiceReferences(String clazz, String filter) throws InvalidSyntaxException {
                return null;
            }

            @Override
            public Filter createFilter(String filter) throws InvalidSyntaxException {
                return null;
            }

            @Override
            public void addServiceListener(ServiceListener listener, String filter) throws InvalidSyntaxException {
            }

            @Override
            public void addServiceListener(ServiceListener listener) {
            }

            @Override
            public void addFrameworkListener(FrameworkListener listener) {
            }

            @Override
            public void addBundleListener(BundleListener listener) {
            }

            @Override
            public <S> ServiceRegistration<S> registerService(Class<S> clazz, ServiceFactory<S> factory, Dictionary<String, ?> properties) {
                return null;
            }

            @Override
            public <S> ServiceObjects<S> getServiceObjects(ServiceReference<S> reference) {
                return null;
            }
        });
        this.log.info("Reading installer state from " + registeredResourceListFile);
        PersistentResourceList persistentResourceList = new PersistentResourceList(registeredResourceListFile, new InstallationListener(){

            @Override
            public void onEvent(InstallationEvent event) {
            }
        });
        this.log.info("Processing installer state...");
        boolean changed = false;
        for (String id : persistentResourceList.getEntityIds()) {
            EntityResourceList erc = persistentResourceList.getEntityResourceList(id);
            ArrayList<RegisteredResourceImpl> toBeRemovedResourceList = new ArrayList<RegisteredResourceImpl>();
            Collection<RegisteredResourceImpl> entityResourceList = erc.listResources();
            for (RegisteredResourceImpl rr : entityResourceList) {
                if (!ResourceState.INSTALL.equals((Object)rr.getState()) || !rr.getScheme().startsWith("fileinstall")) continue;
                this.log.info("- removing state for " + rr.getURL());
                changed = true;
                toBeRemovedResourceList.add(rr);
            }
            for (RegisteredResourceImpl rr : toBeRemovedResourceList) {
                entityResourceList.remove(rr);
            }
        }
        if (changed) {
            persistentResourceList.compact();
            this.log.info("Writing installer state");
            persistentResourceList.save();
        } else {
            this.log.info("No fileinstall configuration found");
        }
    }

    public static enum Mode {
        INSTALL,
        UPGRADE,
        RESTART;

    }
}

