/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.upgrade;

import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.ui.UserInterface;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import org.apache.commons.io.IOUtils;

public class LogFileUpdater {
    private static final String[] SEARCH_PATTERNS = new String[]{"org.apache.sling.commons.log.file=\"../logs/", "access.log.output=\"../logs/", "request.log.output=\"../logs/"};
    private static final String[] REPLACE_PATTERNS = new String[]{"org.apache.sling.commons.log.file=\"logs/", "access.log.output=\"logs/", "request.log.output=\"logs/"};

    public static void updateLogFiles(ProductProperties product, UserInterface ui) throws IOException {
        File configDir;
        File slingDir;
        File launchpadDir = new File(product.getSlingHomeDir(), product.getSlingLaunchpadHome());
        if (launchpadDir.exists() && (slingDir = new File(configDir = new File(launchpadDir, "config"), "org" + File.separatorChar + "apache" + File.separatorChar + "sling")).exists()) {
            LogFileUpdater.process(configDir, ui);
        }
    }

    private static void process(File dir, UserInterface ui) throws IOException {
        File[] children;
        for (File file : children = dir.listFiles()) {
            if (file.isDirectory()) {
                LogFileUpdater.process(file, ui);
                continue;
            }
            LogFileUpdater.convert(file, ui);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void convert(File file, UserInterface ui) throws IOException {
        FileInputStream is = new FileInputStream(file);
        boolean changed = false;
        StringBuilder sb = new StringBuilder();
        try {
            LineNumberReader lnr = new LineNumberReader(new InputStreamReader((InputStream)is, "UTF-8"));
            String line = null;
            while ((line = lnr.readLine()) != null) {
                for (int i = 0; i < SEARCH_PATTERNS.length; ++i) {
                    if (!line.startsWith(SEARCH_PATTERNS[i])) continue;
                    line = REPLACE_PATTERNS[i] + line.substring(SEARCH_PATTERNS[i].length());
                    changed = true;
                    break;
                }
                sb.append(line);
                sb.append("\r\n");
            }
        }
        finally {
            IOUtils.closeQuietly(is);
        }
        if (changed) {
            FileOutputStream os = new FileOutputStream(file);
            try {
                ui.debug("Update: Upgrading log file " + file);
                OutputStreamWriter writer = new OutputStreamWriter((OutputStream)os, "UTF-8");
                writer.write(sb.toString());
                ((Writer)writer).flush();
            }
            finally {
                IOUtils.closeQuietly(os);
            }
        }
    }
}

