/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.ui;

public class StringAbbreviator {
    private static final String SPACE = " ";
    private static final String DEFAULT_ELLIPSIS = "...";

    public String abbreviate(String str, int maxLength) {
        if (str == null) {
            return null;
        }
        if (str.length() <= maxLength) {
            return str;
        }
        if (maxLength < DEFAULT_ELLIPSIS.length()) {
            return DEFAULT_ELLIPSIS.substring(0, maxLength);
        }
        int charsLeft = maxLength - DEFAULT_ELLIPSIS.length();
        String[] words = str.trim().split(SPACE);
        StringBuilder begin = new StringBuilder();
        StringBuilder end = new StringBuilder();
        if (words.length == 1) {
            StringAbbreviator.addUpTo(begin, words[0], true, charsLeft);
        } else {
            int i = 0;
            for (int j = words.length - 1; !(i > j || charsLeft <= 0 || begin.length() > 0 && (charsLeft = StringAbbreviator.addUpTo(begin, SPACE, true, charsLeft)) <= 0 || (charsLeft = StringAbbreviator.addUpTo(begin, words[i], true, charsLeft)) <= 0 || i == j || end.length() > 0 && (charsLeft = StringAbbreviator.addUpTo(end, SPACE, false, charsLeft)) <= 0 || (charsLeft = StringAbbreviator.addUpTo(end, words[j], false, charsLeft)) <= 0); ++i, --j) {
            }
        }
        StringBuilder sb = new StringBuilder();
        sb.append(begin.toString());
        sb.append(DEFAULT_ELLIPSIS);
        sb.append(end.toString());
        return sb.toString();
    }

    private static int addUpTo(StringBuilder sb, String str, boolean appendAtEnd, int charsLeft) {
        if (str.length() > charsLeft) {
            str = appendAtEnd ? str.substring(0, charsLeft) : str.substring(str.length() - charsLeft, str.length());
        }
        if (appendAtEnd) {
            sb.append(str);
        } else {
            sb.insert(0, str);
        }
        return charsLeft - str.length();
    }
}

