/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.ui;

import com.adobe.granite.quickstart.base.impl.exec.ResourceProvider;
import java.awt.Graphics;
import java.awt.Image;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JProgressBar;
import javax.swing.plaf.basic.BasicProgressBarUI;

public class ProgressBarUI
extends BasicProgressBarUI {
    private final int minDisplayWidth;
    private final Image backgroundImg;
    private final ImageIcon mainImg;
    private final Image maskImg;

    public ProgressBarUI(ResourceProvider rp, int minDisplayWidth) throws IllegalArgumentException {
        this.minDisplayWidth = minDisplayWidth;
        this.backgroundImg = this.loadImage(rp, "gui_pb_background.gif", "gui_pb_background.png");
        this.mainImg = this.loadIcon(rp, "gui_pb_main.gif", "gui_pb_main.png");
        this.maskImg = this.loadImage(rp, "gui_pb_mask.gif", "gui_pb_mask.png");
    }

    private Image loadImage(ResourceProvider rp, String ... paths) throws IllegalArgumentException {
        IllegalArgumentException last = null;
        for (String path : paths) {
            try {
                return rp.loadImage(this.getClass(), path);
            }
            catch (IllegalArgumentException e) {
                last = e;
            }
        }
        throw last;
    }

    private ImageIcon loadIcon(ResourceProvider rp, String ... paths) throws IllegalArgumentException {
        IllegalArgumentException last = null;
        for (String path : paths) {
            try {
                return rp.loadIcon(this.getClass(), path);
            }
            catch (IllegalArgumentException e) {
                last = e;
            }
        }
        throw last;
    }

    @Override
    public void paintDeterminate(Graphics g, JComponent c) {
        JProgressBar p = (JProgressBar)c;
        p.setBorderPainted(false);
        p.setOpaque(false);
        if (p.getOrientation() == 0) {
            int pbWidth = c.getWidth();
            int pbHeight = c.getHeight();
            g.drawImage(this.backgroundImg, 0, 0, pbWidth, pbHeight, p);
            if (this.progressBar.getValue() > this.minDisplayWidth) {
                g.drawImage(this.mainImg.getImage(), 0, 0, pbWidth, pbHeight, p);
                if (this.progressBar.getValue() > this.minDisplayWidth) {
                    g.drawImage(this.maskImg, this.progressBar.getValue(), 0, p);
                }
            }
        } else {
            super.paintDeterminate(g, c);
        }
    }
}

