/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.ui;

import com.adobe.granite.quickstart.base.impl.exec.ResourceProvider;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import javax.swing.JPanel;

public class ImagePanel
extends JPanel {
    private int status;
    private final Image[] image;
    private final Rectangle stopButtonBounds;
    private final Cursor defaultCursor;
    static final int STATUS_START = 0;
    static final int STATUS_RUNNING = 1;
    static final int STATUS_SHUTDOWN = 2;

    ImagePanel(ResourceProvider rp, Rectangle theStopButtonBounds) {
        this.stopButtonBounds = theStopButtonBounds;
        this.defaultCursor = this.getCursor();
        this.image = new Image[3];
        this.image[0] = rp.loadImage(this.getClass(), "gui_bg_start.png");
        this.image[1] = rp.loadImage(this.getClass(), "gui_bg_on_blank.png");
        this.image[2] = rp.loadImage(this.getClass(), "gui_bg_off.png");
        Dimension d = new Dimension(this.image[0].getWidth(null), this.image[0].getHeight(null));
        this.setPreferredSize(d);
        this.setMinimumSize(d);
        this.setMaximumSize(d);
        this.setSize(d);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                ImagePanel.this.onMouseClicked(e);
            }
        });
        this.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseMoved(MouseEvent e) {
                if (ImagePanel.this.stopButtonBounds.contains(e.getPoint()) && ImagePanel.this.status == 1) {
                    ImagePanel.this.setCursor(Cursor.getPredefinedCursor(12));
                } else {
                    ImagePanel.this.setCursor(ImagePanel.this.defaultCursor);
                }
            }
        });
        this.setStatus(0);
    }

    private void onMouseClicked(MouseEvent e) {
        if (this.status == 1 && this.stopButtonBounds.contains(e.getPoint())) {
            this.onStopButtonClicked();
        }
    }

    protected void onStopButtonClicked() {
        System.err.println("Stop button clicked - this is meant to be overridden");
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        g.drawImage(this.image[this.status], 0, 0, null);
    }

    int getStatus() {
        return this.status;
    }

    void setStatus(int status) {
        if (status < 0 || status >= this.image.length) {
            throw new IllegalArgumentException("Invalid state: " + status);
        }
        this.status = status;
        this.repaint(0, 0, this.getWidth(), this.getHeight());
    }
}

