/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.ui;

import com.adobe.granite.quickstart.base.impl.exec.ResourceProvider;
import com.adobe.granite.quickstart.base.impl.ui.BrowserLauncher;
import com.adobe.granite.quickstart.base.impl.ui.ImagePanel;
import com.adobe.granite.quickstart.base.impl.ui.ProgressBarUI;
import com.adobe.granite.quickstart.base.impl.ui.StringAbbreviator;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Image;
import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.lang.reflect.Method;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import javax.swing.SwingUtilities;

public class GuiFrame
extends JFrame {
    public static String PROP_URL_COLOR = "gui.url.color";
    public static String PROP_CONSOLE_COLOR = "gui.console.color";
    public static String PROP_CONSOLE_FONT = "gui.console.font";
    public static String PROP_CONSOLE_FONT_SIZE = "gui.console.font-size";
    public static String PROP_CONSOLE_PROGRESSBAR_MINWIDTH = "gui.console.progressbar.minWidthToDisplay";
    public static String PROP_INIT_ESTIMATED_TIME = "gui.init.estimatedTime";
    private ImagePanel panel;
    private JLabel infoLabel;
    private JLabel debugLabel;
    private JProgressBar progressBar;
    private StartupThread startupThread;
    URL appUrl;
    URL debugUrl;
    public static final String CHARS_FOR_FONT_WIDTH = "http://www.xyz.com 0123456789 abcdefghijklmmo ABCDEFMMMZ";
    private int infoMaxChars;
    private int debugMaxChars;
    private int upgradeFrameworkStartLevel;
    private int frameworkStartLevel;
    private Properties props = new Properties();
    private final StringAbbreviator stringAbbreviator = new StringAbbreviator();
    private static final float DEBUG_FONT_SIZE_FACTOR = 0.8f;
    private final AtomicBoolean interruptStartupThread = new AtomicBoolean(false);

    public void setInterruptStartupThread(boolean newValue) {
        this.interruptStartupThread.set(newValue);
    }

    public GuiFrame(int upgradeFrameworkStartLevel, int frameworkStartLevel) {
        super("Adobe Quickstart");
        this.upgradeFrameworkStartLevel = upgradeFrameworkStartLevel;
        this.frameworkStartLevel = frameworkStartLevel;
        this.setDefaultCloseOperation(3);
    }

    public void reportErrorAndWait(String msg) {
        JOptionPane.showMessageDialog(this, msg, this.getTitle(), 0);
    }

    public void initialize(ResourceProvider resourceProvider, String windowTitle, String[] windowIcons) {
        this.props = resourceProvider.loadProperties(this.getClass(), "gui.properties");
        this.setTitle(windowTitle);
        if (windowIcons.length > 0) {
            ArrayList<Image> icons = new ArrayList<Image>();
            for (String iconPath : windowIcons) {
                try {
                    icons.add(resourceProvider.loadImage(this.getClass(), iconPath));
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
            this.setIconImagesInternal(icons);
        }
        this.panel = new ImagePanel(resourceProvider, this.getBounds("stop.button")){

            @Override
            protected void onStopButtonClicked() {
                this.setStatus(2);
                GuiFrame.this.debug("Shutdown in progress...");
                new DelayedShutdownThread(1000L);
            }
        };
        this.panel.setLayout(null);
        Rectangle panelRect = this.getBounds("gui.console");
        int x = panelRect.x;
        int y = panelRect.y;
        int labelsRightMargin = panelRect.width + panelRect.x;
        Rectangle pbRect = this.getBounds("gui.progressbar");
        Color color = Color.decode(this.props.getProperty(PROP_CONSOLE_COLOR, "0x000000"));
        int labelWidth = (int)this.panel.getPreferredSize().getWidth() - labelsRightMargin;
        this.infoLabel = new JLabel("No info yet...");
        this.setFont(this.infoLabel, "text1");
        Font font = this.infoLabel.getFont();
        this.infoLabel.setForeground(color);
        int labelHeight = this.infoLabel.getFontMetrics(font).getHeight();
        this.panel.add(this.infoLabel);
        int text1LeftOffset = this.getIntProperty("text1", "left.offset");
        this.infoLabel.setBounds(x += text1LeftOffset, y += this.getIntProperty("text1", "top.offset"), labelWidth, labelHeight);
        x -= text1LeftOffset;
        y += this.infoLabel.getHeight();
        this.infoMaxChars = (this.infoLabel.getWidth() - labelsRightMargin) / GuiFrame.getCharWidth(this.infoLabel);
        this.debugLabel = new JLabel("");
        this.debugLabel.setForeground(color);
        if (!this.setFont(this.debugLabel, "text2")) {
            float newSize = (float)font.getSize() * 0.8f;
            this.debugLabel.setFont(font.deriveFont(newSize));
        }
        this.panel.add(this.debugLabel);
        int text2LeftOffset = this.getIntProperty("text2", "left.offset");
        this.debugLabel.setBounds(x += text2LeftOffset, y += this.getIntProperty("text2", "top.offset"), labelWidth, labelHeight);
        x -= text2LeftOffset;
        y += this.debugLabel.getHeight();
        this.debugMaxChars = (this.debugLabel.getWidth() - labelsRightMargin) / GuiFrame.getCharWidth(this.debugLabel);
        this.debugLabel.setVisible(false);
        this.progressBar = new JProgressBar(0, pbRect.width);
        try {
            this.progressBar.setUI(new ProgressBarUI(new ResourceProvider(), Integer.decode(this.props.getProperty(PROP_CONSOLE_PROGRESSBAR_MINWIDTH, "0"))));
        }
        catch (IllegalArgumentException e) {
            System.err.println("Unable to initialize progress bar UI: " + e.getMessage());
        }
        this.progressBar.setValue(0);
        this.progressBar.setBounds(pbRect.x, pbRect.y, pbRect.width, pbRect.height);
        this.panel.add(this.progressBar);
        this.add(this.panel);
        this.pack();
        this.infoLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent event) {
                GuiFrame.this.infoLabelClicked(event);
            }
        });
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int wx = (screenSize.width - this.getWidth()) / 2;
        int wy = (screenSize.height - this.getHeight()) / 3;
        this.setLocation(wx, wy);
        this.setResizable(false);
        this.setVisible(true);
        this.setStatus(0);
        if (this.upgradeFrameworkStartLevel > 0 && this.frameworkStartLevel > 0) {
            this.startupThread = new StartupThread(Long.decode(this.props.getProperty(PROP_INIT_ESTIMATED_TIME, "0")), (float)this.upgradeFrameworkStartLevel / (float)this.frameworkStartLevel);
        }
    }

    @Override
    public Insets getInsets() {
        Insets i = super.getInsets();
        i.set(i.top, 0, 0, 0);
        return i;
    }

    private void infoLabelClicked(MouseEvent event) {
        if (this.isInfoClickable()) {
            try {
                new BrowserLauncher().openBrowser(this.appUrl.toString());
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private Rectangle getBounds(String prefix) {
        int x1 = this.getIntProperty(prefix, "left");
        int y1 = this.getIntProperty(prefix, "top");
        int x2 = this.getIntProperty(prefix, "right");
        int y2 = this.getIntProperty(prefix, "bottom");
        return new Rectangle(x1, y1, x2 - x1, y2 - y1);
    }

    private boolean setFont(JComponent c, String propertyPrefix) {
        int style;
        boolean changed = false;
        Font f = c.getFont();
        int size = Integer.decode(this.props.getProperty(propertyPrefix + ".font.size", "0"));
        if (size > 0) {
            changed = true;
            f = f.deriveFont((float)size);
        }
        if ((style = Integer.decode(this.props.getProperty(propertyPrefix + ".font.style", "-1")).intValue()) >= 0) {
            changed = true;
            f = f.deriveFont(style);
        }
        if (changed) {
            c.setFont(f);
        }
        return changed;
    }

    private int getIntProperty(String prefix, String name) {
        String propName = prefix + "." + name;
        if (this.panel != null) {
            switch (this.panel.getStatus()) {
                case 1: {
                    if (!this.props.containsKey(prefix + ".running." + name)) break;
                    propName = prefix + ".running." + name;
                    break;
                }
                case 0: {
                    if (!this.props.containsKey(prefix + ".starting." + name)) break;
                    propName = prefix + ".starting." + name;
                    break;
                }
                case 2: {
                    if (!this.props.containsKey(prefix + ".stopping." + name)) break;
                    propName = prefix + ".stopping." + name;
                }
            }
        }
        return Integer.decode(this.props.getProperty(propName, "0"));
    }

    private boolean isInfoClickable() {
        return this.panel.getStatus() == 1 && this.appUrl != null;
    }

    private void updateCursors() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiFrame.this.infoLabel.setCursor(GuiFrame.this.isInfoClickable() ? new Cursor(12) : null);
            }
        });
    }

    public void info(String str) {
        this.info(str, null);
    }

    private void info(final String str, String url) {
        this.appUrl = null;
        if (url != null) {
            try {
                this.appUrl = new URL(url);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiFrame.this.infoLabel.setText("<html>\n" + GuiFrame.this.stringAbbreviator.abbreviate(str, GuiFrame.this.infoMaxChars));
            }
        });
        this.updateCursors();
    }

    public void debug(String str) {
        this.debug(str, null);
    }

    private void debug(String str, String urlString) {
        URL url = null;
        if (urlString != null) {
            try {
                url = new URL(urlString);
            }
            catch (MalformedURLException malformedURLException) {
                // empty catch block
            }
        }
        final String toDisplay = str;
        final URL toUrl = url;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                GuiFrame.this.debugLabel.setText("<html>\n" + GuiFrame.this.stringAbbreviator.abbreviate(toDisplay, GuiFrame.this.debugMaxChars));
                GuiFrame.this.debugUrl = toUrl;
            }
        });
        this.updateCursors();
    }

    public void startupFinished(String startupInfo, String browserUrl, String statisticsInfo, String statisticsUrl) {
        this.info(startupInfo, browserUrl);
        String urlColor = this.props.getProperty(PROP_URL_COLOR);
        if (urlColor != null) {
            this.infoLabel.setForeground(Color.decode(urlColor));
        }
        this.debug(statisticsInfo, statisticsUrl);
        this.setStatus(1);
    }

    public void startupProgress(float ratio) {
        int currentValue = this.progressBar.getValue();
        int newValue = Math.round(ratio * (float)this.progressBar.getWidth());
        if (newValue > currentValue) {
            for (int i = currentValue + 1; i <= newValue; ++i) {
                try {
                    this.progressBar.setValue(i);
                    Thread.sleep(25L);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    private void setStatus(int status) {
        boolean isRunning = status == 1;
        this.progressBar.setVisible(!isRunning);
        this.debugLabel.setVisible(isRunning);
        this.panel.setStatus(status);
        this.updateCursors();
    }

    private void setIconImagesInternal(List<Image> images) {
        if (!images.isEmpty()) {
            try {
                Method setIconImages = this.getClass().getMethod("setIconImages", List.class);
                setIconImages.invoke((Object)this, images);
            }
            catch (Throwable t) {
                this.setIconImage(images.remove(0));
                for (Image image : images) {
                    image.flush();
                }
            }
        }
    }

    static int getCharWidth(JComponent c) {
        return Toolkit.getDefaultToolkit().getFontMetrics(c.getFont()).stringWidth(CHARS_FOR_FONT_WIDTH) / CHARS_FOR_FONT_WIDTH.length();
    }

    static class DelayedShutdownThread
    extends Thread {
        private final long delay;

        DelayedShutdownThread(long delay) {
            super("DelayedShutdownThread");
            this.delay = delay;
            this.start();
        }

        @Override
        public void run() {
            try {
                Thread.sleep(this.delay);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            System.exit(0);
        }
    }

    class StartupThread
    extends Thread {
        private static final int REFRESH_INTERVAL = 1000;
        private long elapsedTime;
        private final long estimatedTime;
        private final float startLevelRatio;

        StartupThread(long estimatedTime, float startLevelRatio) {
            super("StartupThread");
            this.elapsedTime = 0L;
            this.estimatedTime = estimatedTime * 1000L;
            this.startLevelRatio = startLevelRatio;
            this.start();
        }

        @Override
        public void run() {
            try {
                while (!GuiFrame.this.interruptStartupThread.get() && this.elapsedTime < this.estimatedTime) {
                    GuiFrame.this.startupProgress(this.startLevelRatio * ((float)this.elapsedTime / (float)this.estimatedTime));
                    this.elapsedTime += 1000L;
                    Thread.sleep(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }
}

