/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.stats;

import com.adobe.granite.quickstart.base.impl.Main;
import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.stats.LauncherMBean;
import com.adobe.granite.quickstart.base.impl.stats.StartupStatsProvider;
import com.adobe.granite.quickstart.base.impl.ui.BrowserLauncher;
import com.adobe.granite.quickstart.base.impl.ui.UserInterface;
import com.adobe.granite.quickstart.base.impl.upgrade.UpgradeUtil;
import java.io.BufferedReader;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import org.apache.commons.io.IOUtils;

public class Launcher
implements LauncherMBean {
    private final UserInterface ui;
    private final UpgradeUtil.Mode upgradeMode;
    private final ProductProperties product;
    private final String welcomeUrl;
    private final boolean showBrowser;
    private final int listenerPort;

    public Launcher(UserInterface ui, ProductProperties product, UpgradeUtil.Mode mode, String welcomeUrl, boolean showBrowser, int listenerPort) throws Exception {
        this.ui = ui;
        this.product = product;
        this.upgradeMode = mode;
        this.welcomeUrl = welcomeUrl;
        this.showBrowser = showBrowser;
        this.listenerPort = listenerPort;
    }

    @Override
    public void log(String text) {
        this.ui.info(text);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void startupFinished() {
        if (this.showBrowser) {
            this.ui.info("Server ready, launching " + this.welcomeUrl);
            try {
                new BrowserLauncher().openBrowser(this.welcomeUrl);
            }
            catch (Exception e) {
                this.ui.debug(e.toString());
            }
        } else {
            this.ui.debug("Browser opening disabled by nobrowser option");
        }
        long startupTime = System.currentTimeMillis() - Main.getJvmStartTime();
        long secs = startupTime / 1000L;
        String operationName = this.upgradeMode == UpgradeUtil.Mode.INSTALL ? "Installation" : "Startup";
        StartupStatsProvider startupStatsProvider = new StartupStatsProvider(this.product.getProperty("startup.chart.size"));
        this.ui.startupFinished(this.welcomeUrl, this.welcomeUrl, operationName + " time:" + secs + " seconds", startupStatsProvider.getStatsUrl());
        if (this.listenerPort > 0) {
            ArrayList<String> hosts = new ArrayList<String>();
            hosts.add("localhost");
            hosts.add("127.0.0.1");
            boolean done = false;
            for (int index = 0; !done && index < hosts.size(); ++index) {
                String hostName = (String)hosts.get(index);
                int twoMinutes = 120000;
                Socket clientSocket = null;
                DataOutputStream out = null;
                BufferedReader in = null;
                clientSocket = new Socket();
                clientSocket.connect(new InetSocketAddress(hostName, this.listenerPort), 120000);
                clientSocket.setSoTimeout(120000);
                out = new DataOutputStream(clientSocket.getOutputStream());
                in = new BufferedReader(new InputStreamReader(clientSocket.getInputStream()));
                out.writeBytes("started\n");
                in.readLine();
                done = true;
                IOUtils.closeQuietly(in);
                IOUtils.closeQuietly(out);
                if (clientSocket == null) continue;
                try {
                    clientSocket.close();
                }
                catch (IOException iOException) {}
                continue;
                catch (Throwable throwable) {
                    IOUtils.closeQuietly(in);
                    IOUtils.closeQuietly(out);
                    if (clientSocket == null) continue;
                    try {
                        clientSocket.close();
                    }
                    catch (IOException iOException) {}
                    continue;
                    catch (Throwable throwable2) {
                        IOUtils.closeQuietly(in);
                        IOUtils.closeQuietly(out);
                        if (clientSocket != null) {
                            try {
                                clientSocket.close();
                            }
                            catch (IOException iOException) {
                                // empty catch block
                            }
                        }
                        throw throwable2;
                    }
                }
            }
        }
    }

    @Override
    public void startupProgress(Float ratio) {
        this.ui.startupProgress(ratio.floatValue());
    }
}

