/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.logging;

import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.FileAppender;
import java.io.File;
import org.slf4j.LoggerFactory;

public class LoggingUtil {
    public static final String DEFAULT_LOGGER_PATTERN = "%date{dd.MM.yyyy HH:mm:ss.SSS} %-7(*%level*) %-40([%logger] %F:%-4L) %msg%n";

    public static void redirectLoggers(File slingHome) {
        LoggerContext loggerContext = (LoggerContext)LoggerFactory.getILoggerFactory();
        File logHome = new File(slingHome, "logs");
        PatternLayoutEncoder encoder = new PatternLayoutEncoder();
        encoder.setContext(loggerContext);
        encoder.setPattern(DEFAULT_LOGGER_PATTERN);
        encoder.start();
        FileAppender<ILoggingEvent> upgradeFileAppender = new FileAppender<ILoggingEvent>();
        upgradeFileAppender.setContext(loggerContext);
        upgradeFileAppender.setFile(new File(logHome, "upgrade.log").getAbsolutePath());
        upgradeFileAppender.setEncoder(encoder);
        upgradeFileAppender.start();
        Logger logger = loggerContext.getLogger("com.adobe.granite.quickstart.base.impl.upgrade");
        logger.detachAndStopAllAppenders();
        logger.addAppender((Appender<ILoggingEvent>)upgradeFileAppender);
    }
}

