/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.io;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.util.zip.ZipInputStream;

public class JarReader {
    private final URL jarURL;

    public JarReader(Class<?> c) throws MalformedURLException {
        if (c == null) {
            throw new IllegalArgumentException("Class is null, cannot find jar");
        }
        ProtectionDomain pd = c.getProtectionDomain();
        assert (pd != null);
        CodeSource cs = pd.getCodeSource();
        assert (cs != null);
        URL loc = cs.getLocation();
        assert (loc != null);
        this.jarURL = new URL(loc.toString());
    }

    public String getJarName() {
        return this.jarURL.toString();
    }

    public ZipInputStream getZipInputStream() throws IOException {
        return new ZipInputStream(this.jarURL.openStream());
    }
}

