/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.io;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class DiskUtils {
    private static int maxOpenFiles = 0;

    public static int getMaxOpenFiles(boolean isWindows) {
        if (maxOpenFiles != 0) {
            return maxOpenFiles;
        }
        if (isWindows) {
            maxOpenFiles = Integer.MAX_VALUE;
        } else {
            String result = "";
            try {
                result = DiskUtils.runProcess(new String[]{"ulimit", "-n"}).trim();
                maxOpenFiles = Integer.parseInt(result);
            }
            catch (Exception e) {
                maxOpenFiles = Integer.MAX_VALUE;
            }
        }
        return maxOpenFiles;
    }

    private static Thread copyInThread(final InputStream in, final OutputStream out, final boolean toSysOut) {
        Thread t = new Thread(){

            @Override
            public void run() {
                try {
                    while (true) {
                        int x;
                        if ((x = in.read()) < 0) {
                            return;
                        }
                        if (out == null) continue;
                        out.write(x);
                        if (!toSysOut) continue;
                        System.out.print((char)x);
                    }
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        };
        t.start();
        return t;
    }

    private static String runProcess(String[] argList) {
        try {
            Process p = Runtime.getRuntime().exec(argList);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            Thread threadOut = DiskUtils.copyInThread(p.getInputStream(), out, false);
            Thread threadErr = DiskUtils.copyInThread(p.getErrorStream(), out, false);
            p.waitFor();
            p.exitValue();
            threadOut.join();
            threadErr.join();
            String result = new String(out.toByteArray());
            return result;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (InterruptedException e) {
            throw new RuntimeException(e);
        }
    }
}

