/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.exec;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;

public class StandardStreamsHandler {
    final PrintStream originalSystemErr = System.err;
    final PrintStream originalSystemOut = System.out;
    BufferCopyOutputStream bufferErr = new BufferCopyOutputStream(System.err);
    BufferCopyOutputStream bufferOut = new BufferCopyOutputStream(System.out);

    public StandardStreamsHandler() {
        System.setErr(new PrintStream(this.bufferErr, true));
        System.setOut(new PrintStream(this.bufferOut, true));
    }

    public void switchToLogFiles(File logDir) throws IOException {
        File out = new File(logDir, "stdout.log");
        System.err.println("Redirecting stdout to " + out.getAbsolutePath());
        System.setOut(new PrintStream(new FileOutputStream(out)));
        this.copyStream(this.bufferOut, System.out);
        File err = new File(logDir, "stderr.log");
        System.err.println("Redirecting stderr to " + err.getAbsolutePath());
        System.setErr(new PrintStream(new FileOutputStream(err)));
        this.copyStream(this.bufferErr, System.err);
        this.destroyBuffers();
    }

    public void switchToOriginalStreams() {
        System.setErr(this.originalSystemErr);
        System.setOut(this.originalSystemOut);
        this.destroyBuffers();
    }

    private void destroyBuffers() {
        this.bufferOut = null;
        this.bufferErr = null;
    }

    private void copyStream(BufferCopyOutputStream src, OutputStream dest) throws IOException {
        src.flush();
        for (byte b : src.buffer.toByteArray()) {
            dest.write(b);
        }
        dest.flush();
    }

    public PrintStream getOriginalSystemErr() {
        return this.originalSystemErr;
    }

    public PrintStream getOriginalSystemOut() {
        return this.originalSystemOut;
    }

    static class BufferCopyOutputStream
    extends OutputStream {
        final ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        final OutputStream chainedStream;

        BufferCopyOutputStream(OutputStream chainedStream) {
            this.chainedStream = chainedStream;
        }

        @Override
        public void write(int c) throws IOException {
            this.chainedStream.write(c);
            this.buffer.write(c);
        }

        @Override
        public void close() throws IOException {
            this.flush();
            this.chainedStream.close();
            this.buffer.close();
        }

        @Override
        public void flush() throws IOException {
            this.chainedStream.flush();
            this.buffer.flush();
        }
    }
}

