/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.exec;

import java.awt.Image;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Arrays;
import java.util.Properties;
import javax.swing.ImageIcon;
import org.apache.commons.io.IOUtils;

public class ResourceProvider {
    private final String[] paths;
    private static final String SLASH = "/";

    public ResourceProvider() {
        this("/gui", "/gui/default");
    }

    public ResourceProvider(String ... paths) {
        this.paths = paths;
        this.debug("ResourceProvider paths=%s", Arrays.asList(paths));
    }

    public String toString() {
        return "ResourceProvider, paths=" + Arrays.asList(this.paths);
    }

    public InputStream getResourceAsStream(Class<?> c, String resourcePath) {
        for (String basePath : this.paths) {
            String path = ResourceProvider.fullPath(basePath, resourcePath);
            InputStream is = c.getResourceAsStream(path);
            if (is == null) continue;
            this.debug("getResourceAsStream: found %s", path);
            return is;
        }
        return null;
    }

    public URL getResourceURL(Class<?> c, String resourcePath) {
        for (String basePath : this.paths) {
            String path = ResourceProvider.fullPath(basePath, resourcePath);
            URL u = c.getResource(path);
            if (u == null) continue;
            this.debug("getResourceURL: found %s", path);
            return u;
        }
        return null;
    }

    public Image loadImage(Class<?> c, String path) {
        return this.loadIcon(c, path).getImage();
    }

    public ImageIcon loadIcon(Class<?> c, String path) {
        URL url = this.getResourceURL(c, path);
        if (url == null) {
            throw new IllegalArgumentException("Image resource not found: " + path);
        }
        return new ImageIcon(url);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Properties loadProperties(Class<?> c, String name) {
        Properties props = new Properties();
        for (int i = this.paths.length; i > 0; --i) {
            String path = ResourceProvider.fullPath(this.paths[i - 1], name);
            InputStream is = c.getResourceAsStream(path);
            if (is == null) continue;
            this.debug("loadProperties: found %s", path);
            try {
                props.load(is);
                continue;
            }
            catch (IOException e) {
                this.debug("Unable to load " + name + " : " + e.getMessage(), new Object[0]);
                continue;
            }
            finally {
                IOUtils.closeQuietly(is);
            }
        }
        return props;
    }

    public static String fullPath(String basePath, String resourcePath) {
        StringBuilder sb = new StringBuilder();
        if (basePath.endsWith(SLASH)) {
            sb.append(basePath.substring(0, basePath.length() - 1));
        } else {
            sb.append(basePath);
        }
        if (!resourcePath.startsWith(SLASH)) {
            sb.append(SLASH);
        }
        sb.append(resourcePath);
        return sb.toString();
    }

    protected void debug(String format, Object ... args) {
    }
}

