/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl.exec;

import java.io.IOException;
import java.net.InetAddress;
import java.net.ServerSocket;

public class PortSelector {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int selectPort(String possiblePorts, InetAddress bindAddress) throws IOException {
        int result = -1;
        String interfaceInfo = bindAddress == null ? "" : " on interface " + bindAddress;
        this.debug("Selecting server port from supplied list: " + possiblePorts + interfaceInfo);
        for (String str : possiblePorts.split(",")) {
            ServerSocket s = null;
            try {
                if ("random".equalsIgnoreCase(str)) {
                    this.debug("Trying randomly allocated port number" + interfaceInfo);
                    s = new ServerSocket(0, -1, bindAddress);
                    result = s.getLocalPort();
                    break;
                }
                int port = Integer.parseInt(str);
                this.debug("Trying port " + port + interfaceInfo);
                s = new ServerSocket(port, -1, bindAddress);
                this.debug("Successfully bound to port " + port + ", will use it" + interfaceInfo);
                result = port;
                break;
            }
            catch (NumberFormatException nfe) {
                throw new NumberFormatException("Invalid port number: '" + str + "'");
            }
            catch (IOException ioe) {
                this.debug(ioe.toString());
            }
            finally {
                if (s != null) {
                    try {
                        s.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        if (result == -1) {
            throw new IOException("Did not find an available server port, tried " + possiblePorts + interfaceInfo);
        }
        this.debug("Selected port " + result + interfaceInfo);
        return result;
    }

    protected void debug(String str) {
    }
}

