/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import com.adobe.granite.quickstart.base.impl.ProductProperties;
import java.io.PrintStream;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryPoolMXBean;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;

public class VmSettings {
    public static final String PERMGEN_MBEAN_DEFAULT_REGEXP = "^.*Perm.*Gen$";
    public static final String DEFAULT_FORK_ARGS_PREFIX = "jvm.default.fork.args.";
    public static final String MIN_HEAP_MB_PREFIX = "jvm.min.heap.mb.";
    public static final String MIN_PERMGEN_MB_PREFIX = "jvm.min.permgen.mb.";
    public static final int ACCEPTED_DELTA_MB = 20;
    private final String[] defaultForkArgs;
    private final int minHeapMb;
    private final int minPermgenMb;
    private final int bits = VmSettings.is64bit() ? 64 : 32;

    public VmSettings(ProductProperties config) throws Exception {
        this.defaultForkArgs = config.getRequiredProperty(DEFAULT_FORK_ARGS_PREFIX + this.bits).split(" ");
        this.minHeapMb = Integer.parseInt(config.getRequiredProperty(MIN_HEAP_MB_PREFIX + this.bits));
        this.minPermgenMb = Integer.parseInt(config.getRequiredProperty(MIN_PERMGEN_MB_PREFIX + this.bits));
    }

    public String toString() {
        return this.bits + "bit VM settings, min.heap=" + this.minHeapMb + "MB, min permgen=" + this.minPermgenMb + "MB, default fork arguments=" + Arrays.asList(this.defaultForkArgs);
    }

    public String[] getDefaultForkArgs() {
        return this.defaultForkArgs;
    }

    static boolean is64bit() {
        String arch = System.getProperty("os.arch");
        return arch != null && (arch.contains("64") || arch.endsWith(".0W"));
    }

    public boolean checkMemory(PrintStream logStream, String forkHint) {
        logStream.println("Using " + this);
        boolean result = true;
        result &= this.checkHeapSize(logStream, this.getMinHeapMb(), forkHint);
        return result &= this.checkPermGenSize(logStream, this.getMinPermGenMb(), PERMGEN_MBEAN_DEFAULT_REGEXP, forkHint);
    }

    public Set<String> getAvailableSystemModuleNames() {
        HashSet<String> modules = new HashSet<String>();
        ClassLoader cl = VmSettings.class.getClassLoader();
        try {
            Class<?> moduleFinderCls = cl.loadClass("java.lang.module.ModuleFinder");
            Method ofSystemMtd = moduleFinderCls.getMethod("ofSystem", new Class[0]);
            Method findAllMtd = moduleFinderCls.getMethod("findAll", new Class[0]);
            Class<?> moduleReferenceCls = cl.loadClass("java.lang.module.ModuleReference");
            Method descriptorMtd = moduleReferenceCls.getMethod("descriptor", new Class[0]);
            Class<?> moduleDescriptorCls = cl.loadClass("java.lang.module.ModuleDescriptor");
            Method nameMtd = moduleDescriptorCls.getMethod("name", new Class[0]);
            Object moduleFinder = ofSystemMtd.invoke(null, new Object[0]);
            Set moduleRefs = (Set)findAllMtd.invoke(moduleFinder, new Object[0]);
            for (Object moduleRef : moduleRefs) {
                Object descriptor = descriptorMtd.invoke(moduleRef, new Object[0]);
                String moduleName = (String)nameMtd.invoke(descriptor, new Object[0]);
                modules.add(moduleName);
            }
            return modules;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    public Set<String> getLoadedModuleNames() {
        HashSet<String> moduleNames = new HashSet<String>();
        ClassLoader cl = VmSettings.class.getClassLoader();
        try {
            Class<?> c_ModuleLayer = cl.loadClass("java.lang.ModuleLayer");
            Class<?> c_Module = cl.loadClass("java.lang.Module");
            Method m_getLayer = c_Module.getMethod("getLayer", new Class[0]);
            Method m_getModule = Class.class.getMethod("getModule", new Class[0]);
            Method m_canRead = c_Module.getMethod("canRead", c_Module);
            Method m_getName = c_Module.getMethod("getName", new Class[0]);
            Object self = m_getModule.invoke(VmSettings.class, new Object[0]);
            Object moduleLayer = m_getLayer.invoke(self, new Object[0]);
            if (moduleLayer == null) {
                moduleLayer = c_ModuleLayer.getMethod("boot", new Class[0]).invoke(null, new Object[0]);
            }
            for (Object module : (Iterable)c_ModuleLayer.getMethod("modules", new Class[0]).invoke(moduleLayer, new Object[0])) {
                if (!((Boolean)m_canRead.invoke(self, module)).booleanValue()) continue;
                Object name = m_getName.invoke(module, new Object[0]);
                moduleNames.add((String)name);
            }
            return moduleNames;
        }
        catch (ReflectiveOperationException e) {
            return null;
        }
    }

    protected int getMinHeapMb() {
        return this.minHeapMb;
    }

    protected int getMinPermGenMb() {
        return this.minPermgenMb;
    }

    protected boolean checkHeapSize(PrintStream logStream, int minHeapSize, String forkHint) {
        boolean ok;
        long heapMb = this.bytesToMegabyte(Runtime.getRuntime().maxMemory());
        boolean bl = ok = heapMb >= (long)(minHeapSize - 20);
        if (!ok) {
            if (logStream != null) {
                String header = "**** WARNING: insufficent heap memory ******************************************";
                String footer = "********************************************************************************";
                logStream.println("**** WARNING: insufficent heap memory ******************************************");
                logStream.println("The JVM reports " + heapMb + " MB but we recommend at least " + minHeapSize + " MB +/- " + 20);
                logStream.println("Use your JVM's heap size option (like -Xmx" + minHeapSize + "M) to set that size.");
                logStream.println(forkHint);
                logStream.println("********************************************************************************");
            }
        } else {
            System.err.println("The JVM reports a heap size of " + heapMb + " MB, meets our expectation of " + minHeapSize + " MB +/- " + 20);
        }
        return ok;
    }

    protected long bytesToMegabyte(long nBytes) {
        long bytesPerMegabyte = 0x100000L;
        return nBytes / 0x100000L;
    }

    protected boolean checkPermGenSize(PrintStream logStream, int minSizeMb, String permGenMbeanRegexp, String forkHint) {
        Pattern p = Pattern.compile(permGenMbeanRegexp);
        List<MemoryPoolMXBean> beans = ManagementFactory.getMemoryPoolMXBeans();
        boolean ok = true;
        for (MemoryPoolMXBean b : beans) {
            if (!p.matcher(b.getName()).matches()) continue;
            long mb = this.bytesToMegabyte(b.getUsage().getMax());
            if (mb < (long)(minSizeMb - 20)) {
                ok = false;
                if (logStream == null) continue;
                String header = "**** WARNING: insufficent PermGen memory ***************************************";
                String footer = "********************************************************************************";
                logStream.println("**** WARNING: insufficent PermGen memory ***************************************");
                logStream.println("The JVM MBean:" + b.getName() + " reports " + mb + " MB but we recommend at least " + minSizeMb + " MB +/- " + 20);
                logStream.println("Use your JVM's PermGen size option (like -XX:MaxPermSize=" + minSizeMb + "M) to set that size.");
                logStream.println(forkHint);
                logStream.println("********************************************************************************");
                continue;
            }
            System.err.println("The JVM MBean:" + b.getName() + " reports a maximum size of " + mb + " MB, meets our expectation of " + minSizeMb + " MB +/- " + 20);
        }
        return ok;
    }
}

