/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import com.adobe.granite.quickstart.base.impl.Constants;
import com.adobe.granite.quickstart.base.impl.Main;
import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.io.IOUtils;
import com.adobe.granite.quickstart.base.impl.io.JarReader;
import com.adobe.granite.quickstart.base.impl.ui.UserInterface;
import com.adobe.granite.quickstart.base.impl.upgrade.UpgradeUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;

public class Unpacker {
    private static final String PROP_UPGRADE_IGNORE_REGEXP = "upgrade.ignore.files.regexp";
    private static final String PROP_EXECUTABLE_SCRIPTS = "executable.scripts.list";
    private final ProductProperties product;
    private final UserInterface ui;
    private final List<String> executables = new ArrayList<String>();

    public Unpacker(ProductProperties product, UserInterface ui) throws Exception {
        String[] scripts;
        this.product = product;
        this.ui = ui;
        for (String s : scripts = this.product.getRequiredProperty(PROP_EXECUTABLE_SCRIPTS).split(",")) {
            this.executables.add(s);
        }
    }

    public void unpack(UpgradeUtil.Mode mode) throws Exception {
        if (mode == UpgradeUtil.Mode.RESTART) {
            return;
        }
        this.ui.info("Extracting static files to work directory...");
        this.extractFiles(mode);
    }

    public void markExecutables() {
        if (!Main.isWindows()) {
            this.ui.info("Making scripts executable...");
            try {
                for (String script : this.executables) {
                    File f = new File(this.product.getSlingHomeDir(), script);
                    String cmd = "chmod +x " + f.getAbsolutePath();
                    this.ui.debug("Running " + cmd);
                    Process p = Runtime.getRuntime().exec(cmd);
                    int result = p.waitFor();
                    p.getInputStream().close();
                    p.getOutputStream().close();
                    p.getErrorStream().close();
                    if (result == 0) continue;
                    throw new IOException(cmd + " command returned non-zero exit code:" + result);
                }
            }
            catch (Exception e) {
                this.ui.info("Failed to set executable mode on scripts: " + e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void extractFiles(UpgradeUtil.Mode mode) throws IOException {
        String ignoreStr;
        Pattern ignoreDuringUpgradePattern = null;
        if (mode == UpgradeUtil.Mode.UPGRADE && (ignoreStr = this.product.getProperty(PROP_UPGRADE_IGNORE_REGEXP)) != null) {
            ignoreDuringUpgradePattern = Pattern.compile(ignoreStr);
        }
        String PREFIX = "static/";
        String newFileSuffix = ".NEW_" + Constants.ARCHIVE_ID;
        int acceptedFiles = 0;
        ZipInputStream zis = new JarReader(this.getClass()).getZipInputStream();
        try {
            ZipEntry entry = null;
            while ((entry = zis.getNextEntry()) != null) {
                String path = entry.getName();
                if (!path.startsWith("static/")) continue;
                String name = path.substring("static/".length());
                try {
                    File toCreate = new File(this.product.getSlingHomeDir(), name);
                    if (entry.isDirectory()) {
                        if (toCreate.exists() || toCreate.mkdirs()) continue;
                        throw new IOException("Cannot create directory " + toCreate.getAbsolutePath());
                    }
                    boolean copy = true;
                    if (ignoreDuringUpgradePattern != null && ignoreDuringUpgradePattern.matcher(toCreate.getAbsolutePath()).matches()) {
                        copy = false;
                        this.ui.debug("Ignored due to upgrade.ignore.files.regexp instance property : " + toCreate.getAbsolutePath());
                    }
                    if (!copy) continue;
                    ++acceptedFiles;
                    if (!toCreate.exists() || !this.executables.contains(name)) {
                        IOUtils.copyToFile(zis, toCreate);
                        continue;
                    }
                    File f = new File(toCreate.getParentFile(), name + newFileSuffix);
                    IOUtils.copyToFile(zis, f);
                    if (this.sameContent(toCreate, f)) {
                        f.delete();
                        this.ui.debug("File exists and cannot be overwritten, but unchanged: " + toCreate.getAbsolutePath());
                        continue;
                    }
                    this.ui.debug("File exists and cannot be overwritten, extracted to " + f.getName() + " instead of " + toCreate.getAbsolutePath());
                }
                finally {
                    zis.closeEntry();
                }
            }
        }
        finally {
            org.apache.commons.io.IOUtils.closeQuietly(zis);
        }
        this.ui.debug(acceptedFiles + " files extracted from jar file");
    }

    protected boolean sameContent(File a, File b) throws IOException {
        return this.getDigest(a).equals(this.getDigest(b));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getDigest(File f) throws IOException {
        String digestType = "MD5";
        MessageDigest d = null;
        try {
            d = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nse) {
            IOException ioe = new IOException("NoSuchAlgorithmException: MD5");
            ioe.initCause(nse);
            throw ioe;
        }
        byte[] buffer = new byte[32768];
        int count = 0;
        try (FileInputStream in = new FileInputStream(f);){
            while ((count = in.read(buffer, 0, buffer.length)) > 0) {
                d.update(buffer, 0, count);
            }
        }
        BigInteger bigInt = new BigInteger(1, d.digest());
        return new String(bigInt.toString(16));
    }
}

