/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import java.io.PrintWriter;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.HelpLine;
import org.apache.commons.cli2.util.HelpFormatter;

public final class QuickstartHelpFormatter
extends HelpFormatter {
    private static final String SYS_PROP_TERM_WIDTH = "env.term.width";
    private boolean includeFirstDivider = true;
    private int dividerCount;
    private boolean skipToplevel = false;

    private QuickstartHelpFormatter(String gutterLeft, String gutterCenter, String gutterRight, int fullWidth) {
        super(gutterLeft, gutterCenter, gutterRight, fullWidth);
    }

    public QuickstartHelpFormatter withFirstDivider(boolean b) {
        this.includeFirstDivider = b;
        return this;
    }

    public void setSkipToplevel(boolean skipToplevel) {
        this.skipToplevel = skipToplevel;
    }

    @Override
    public void print() {
        this.dividerCount = 0;
        super.print();
    }

    @Override
    public void printDivider() {
        if (this.dividerCount > 0 || this.includeFirstDivider) {
            super.printDivider();
        }
        ++this.dividerCount;
    }

    @Override
    public void printHelp() {
        this.printDivider();
        Group option = this.getGroup();
        PrintWriter out = this.getPrintWriter();
        List helpLines = option.helpLines(this.skipToplevel ? -1 : 0, this.getDisplaySettings(), this.getComparator());
        if (this.skipToplevel) {
            helpLines.remove(0);
        }
        int descLeftMargin = 5;
        StringBuffer blankBuffer = new StringBuffer();
        for (int i = 0; i < 5; ++i) {
            blankBuffer.append(' ');
        }
        out.println();
        int descriptionWidth = Math.max(1, this.getPageWidth() - this.getGutterCenter().length() - 5);
        for (HelpLine helpLine : helpLines) {
            List descList = QuickstartHelpFormatter.wrap(helpLine.getDescription(), descriptionWidth);
            Iterator descriptionIterator = descList.iterator();
            this.printGutterLeft();
            QuickstartHelpFormatter.pad(helpLine.usage(this.getLineUsageSettings(), this.getComparator()), 5, out);
            out.println();
            while (descriptionIterator.hasNext()) {
                this.printGutterLeft();
                out.print(blankBuffer);
                out.print(this.getGutterCenter());
                QuickstartHelpFormatter.pad((String)descriptionIterator.next(), descriptionWidth, out);
                this.printGutterRight();
                out.println();
            }
        }
        this.printDivider();
    }

    public static QuickstartHelpFormatter create() {
        return new QuickstartHelpFormatter("", "    ", "", QuickstartHelpFormatter.getDefaultWidth());
    }

    private static int getDefaultWidth() {
        int w = Integer.getInteger(SYS_PROP_TERM_WIDTH, 80);
        return Math.max(w, 80);
    }

    public void printInfoSection(String description, String text) {
        this.getPrintWriter().println(description);
        this.printDivider();
        Iterator i = QuickstartHelpFormatter.wrap(text, this.getPageWidth() - 2).iterator();
        while (i.hasNext()) {
            this.printGutterLeft();
            this.getPrintWriter().print("  ");
            QuickstartHelpFormatter.pad((String)i.next(), this.getPageWidth() - 2, this.getPrintWriter());
            this.printGutterRight();
            this.getPrintWriter().println();
        }
        this.printDivider();
        this.getPrintWriter().flush();
    }
}

