/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import com.adobe.granite.quickstart.base.impl.FilenameProperties;
import com.adobe.granite.quickstart.base.impl.ProductProperties;
import com.adobe.granite.quickstart.base.impl.Quickstart;
import com.adobe.granite.quickstart.base.impl.QuickstartHelpFormatter;
import com.adobe.granite.quickstart.base.impl.VmSettings;
import com.adobe.granite.quickstart.base.impl.cli.NameValuePair;
import com.adobe.granite.quickstart.base.impl.cli.ValueBasedPropertyOption;
import com.adobe.granite.quickstart.base.impl.exec.ResourceProvider;
import com.adobe.granite.quickstart.base.impl.exec.StandardStreamsHandler;
import com.adobe.granite.quickstart.base.impl.exec.StreamCopyThread;
import com.adobe.granite.quickstart.base.impl.extension.Extension;
import com.adobe.granite.quickstart.base.impl.extension.ExtensionRegistry;
import com.adobe.granite.quickstart.base.impl.io.DiskUtils;
import com.adobe.granite.quickstart.base.impl.io.JarReader;
import com.adobe.granite.quickstart.base.impl.logging.LoggingUtil;
import com.adobe.granite.quickstart.base.impl.ui.GuiFrame;
import java.awt.Image;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.cli2.CommandLine;
import org.apache.commons.cli2.DisplaySetting;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.commandline.DefaultingCommandLine;
import org.apache.commons.cli2.commandline.Parser;
import org.apache.commons.cli2.commandline.PropertiesCommandLine;
import org.apache.commons.cli2.option.DefaultOption;

public class Main {
    private static final String JPMS_REQUIRED_MODULE_NAME = "java.se.ee";
    private static final String PROP_SCRIPTS_RELATIVE_PATH = "scripts.relative.path";
    private Option guiOption;
    private Option portOption;
    private Option contextOption;
    private Option debugOption;
    private Option interfaceOption;
    private Option helpOption;
    private Option noBrowserOption;
    private Option unpackOption;
    private Option verboseOption;
    private Option noForkOption;
    private Option forkOption;
    private Option forkArgsOption;
    private Option processTypeOption;
    private Option runModeOption;
    private Option baseFolderOption;
    private Option lowMemOption;
    private Option useControlPortOption;
    private Option launchpadLogLevelOption;
    private Option noShutdownHookOption;
    private Option fwkPropsOption;
    private Option listenerPortOption;
    private Option executeExtensionOption;
    private Option extensionArgumentsOption;
    private Option noInteractiveOption;
    private ProductProperties product;
    private static final long jvmStartTime = System.currentTimeMillis();
    private VmSettings vmSettings;
    private String processType = "MAIN";
    private Process childProcess;
    private final String childProcessShutdownKey = String.valueOf(System.currentTimeMillis() % 1000L);
    private static final boolean isWindows = System.getProperty("os.name").toLowerCase().contains("windows");
    private String jarFilename;
    private ExtensionRegistry extensions;
    private final boolean stopChildViaStdin = isWindows;

    protected QuickstartHelpFormatter setupHelpFormatter(QuickstartHelpFormatter hf) {
        StringBuffer divider = new StringBuffer(hf.getPageWidth());
        while (divider.length() < hf.getPageWidth()) {
            divider.append("-");
        }
        hf.setDivider(divider.toString());
        hf.setSkipToplevel(true);
        hf.getFullUsageSettings().removeAll(DisplaySetting.ALL);
        hf.getDisplaySettings().remove(DisplaySetting.DISPLAY_GROUP_ARGUMENT);
        hf.getDisplaySettings().add(DisplaySetting.DISPLAY_OPTIONAL);
        hf.getLineUsageSettings().add(DisplaySetting.DISPLAY_PROPERTY_OPTION);
        hf.getLineUsageSettings().add(DisplaySetting.DISPLAY_PARENT_ARGUMENT);
        hf.getLineUsageSettings().add(DisplaySetting.DISPLAY_ARGUMENT_BRACKETED);
        return hf;
    }

    protected QuickstartHelpFormatter getQuickstartHelpFormatter() throws Exception {
        QuickstartHelpFormatter hf = QuickstartHelpFormatter.create();
        hf.setHeader(this.product.getRequiredProperty("gui.window.title"));
        hf.setGroup(this.getCommandLineGroup());
        return this.setupHelpFormatter(hf);
    }

    protected QuickstartHelpFormatter getFilenameHelpFormatter(FilenameProperties patterns) {
        QuickstartHelpFormatter hf = QuickstartHelpFormatter.create();
        hf.setHeader("Quickstart filename options");
        hf.setGroup(this.getFilenameOptionsGroup(patterns));
        return this.setupHelpFormatter(hf);
    }

    protected Group getFilenameOptionsGroup(FilenameProperties patterns) {
        GroupBuilder gb = new GroupBuilder();
        gb.withName("Rename the jar file, including one of the patterns shown below, to set the corresponding option. Command-line options have priority on these filename patterns.");
        for (FilenameProperties.FilenamePattern p : patterns.getPatterns()) {
            if (p.getExample() == null || p.getDescription() == null) continue;
            DefaultOption opt = new DefaultOptionBuilder().withShortName(p.getExample()).withDescription(p.getDescription()).create();
            gb.withOption(opt);
        }
        return gb.create();
    }

    protected Group getCommandLineGroup() {
        this.portOption = new DefaultOptionBuilder().withShortName("quickstart.server.port").withShortName("port").withShortName("p").withDescription("Set server port number").withArgument(new ArgumentBuilder().withName("port").withMinimum(1).withMaximum(1).create()).create();
        this.contextOption = new DefaultOptionBuilder().withShortName("contextpath").withShortName("c").withShortName("org.apache.felix.http.context_path").withDescription("Set context path").withArgument(new ArgumentBuilder().withName("contextpath").withMinimum(1).withMaximum(1).create()).create();
        this.debugOption = new DefaultOptionBuilder().withShortName("debug").withDescription("Enable Java Debugging on port number; forces forking").withArgument(new ArgumentBuilder().withName("port").withMinimum(1).withMaximum(1).create()).create();
        this.interfaceOption = new DefaultOptionBuilder().withShortName("a").withLongName("interface").withDescription("Optional IP address (interface) to bind to").withArgument(new ArgumentBuilder().withName("interface").withMinimum(1).withMaximum(1).create()).create();
        this.guiOption = new DefaultOptionBuilder().withShortName("gui").withDescription("Show GUI if running on a terminal").create();
        this.helpOption = new DefaultOptionBuilder().withShortName("help").withShortName("h").withLongName("help").withDescription("Show this help message").create();
        this.noBrowserOption = new DefaultOptionBuilder().withShortName("nobrowser").withShortName("quickstart.nobrowser").withDescription("Do not open browser at startup").create();
        this.unpackOption = new DefaultOptionBuilder().withShortName("unpack").withDescription("Unpack installation files only, do not start the server (implies -verbose)").create();
        this.verboseOption = new DefaultOptionBuilder().withShortName("v").withShortName("verbose").withDescription("Do not redirect stdout/stderr to files and do not close stdin").create();
        this.noForkOption = new DefaultOptionBuilder().withShortName("nofork").withDescription("Do not fork the JVM, even if not running on a console").create();
        this.forkOption = new DefaultOptionBuilder().withShortName("fork").withDescription("Force forking the JVM if running on a console, using recommended default memory settings for the forked JVM.").create();
        StringBuilder sb = new StringBuilder();
        for (String arg : this.vmSettings.getDefaultForkArgs()) {
            sb.append(arg);
            sb.append(' ');
        }
        this.forkArgsOption = new DefaultOptionBuilder().withShortName("forkargs").withDescription("Additional arguments for the forked JVM, defaults to '" + sb.toString() + "'.  Use -- to specify values starting with -, example: '-forkargs -- -server'").withArgument(new ArgumentBuilder().withName("args").withMinimum(1).create()).create();
        this.processTypeOption = new DefaultOptionBuilder().withShortName("pt").withArgument(new ArgumentBuilder().withName("string").withMinimum(1).withMaximum(1).create()).withDescription("Process type (main/fork) - do not use directly, used when forking a process").create();
        this.runModeOption = new DefaultOptionBuilder().withShortName("r").withArgument(new ArgumentBuilder().withName("string").withMinimum(1).withMaximum(10).create()).withDescription("Runmode(s) - Use this to define the run mode(s)").create();
        this.baseFolderOption = new DefaultOptionBuilder().withShortName("b").withArgument(new ArgumentBuilder().withName("string").withMinimum(1).withMaximum(1).create()).withDescription("Base folder - defines the path under which the quickstart work folder is created").create();
        this.lowMemOption = new DefaultOptionBuilder().withShortName("low-mem-action").withArgument(new ArgumentBuilder().withName("string").withMinimum(1).withMaximum(1).create()).withDescription("Low memory action - what to do if memory is insufficient at startup").create();
        this.useControlPortOption = new DefaultOptionBuilder().withShortName("use-control-port").withDescription("Start a control port").create();
        this.noInteractiveOption = new DefaultOptionBuilder().withShortName("nointeractive").withDescription("Start with no interactivity").create();
        this.launchpadLogLevelOption = new DefaultOptionBuilder().withShortName("ll").withDescription("Define launchpad log level (1 = error...4 = debug)").withArgument(new ArgumentBuilder().withName("level").withMinimum(1).withMaximum(1).create()).create();
        this.noShutdownHookOption = new DefaultOptionBuilder().withShortName("n").withDescription("Do not install shutdown hook").create();
        this.fwkPropsOption = new ValueBasedPropertyOption("-D", "Additional framework properties.", 68);
        this.listenerPortOption = new DefaultOptionBuilder().withShortName("listener-port").withDescription("Set listener port number").withArgument(new ArgumentBuilder().withName("listener-port").withMinimum(1).withMaximum(1).create()).create();
        this.extensionArgumentsOption = new DefaultOptionBuilder().withShortName("xargs").withDescription("Construct an arguments list for a Quickstart extension (e.g. -xargs -- -arg1 val1 -arg2 val2).").withArgument(new ArgumentBuilder().withMinimum(1).create()).create();
        this.executeExtensionOption = new DefaultOptionBuilder().withShortName("x").withDescription("Run a Quickstart extension.").withArgument(new ArgumentBuilder().withName("string").withMinimum(1).withMaximum(1).create()).withChildren(new GroupBuilder().withName("Options for executing Quickstart extensions:").withOption(this.extensionArgumentsOption).create()).create();
        return new GroupBuilder().withName("Use these options on the Quickstart command line.").withDescription("Set the Quickstart parameters").withOption(this.helpOption).withOption(this.portOption).withOption(this.contextOption).withOption(this.debugOption).withOption(this.guiOption).withOption(this.noBrowserOption).withOption(this.unpackOption).withOption(this.verboseOption).withOption(this.noForkOption).withOption(this.forkOption).withOption(this.forkArgsOption).withOption(this.interfaceOption).withOption(this.processTypeOption).withOption(this.runModeOption).withOption(this.baseFolderOption).withOption(this.lowMemOption).withOption(this.useControlPortOption).withOption(this.noInteractiveOption).withOption(this.launchpadLogLevelOption).withOption(this.noShutdownHookOption).withOption(this.fwkPropsOption).withOption(this.listenerPortOption).withOption(this.executeExtensionOption).create();
    }

    protected void printHelp(FilenameProperties fp) throws Exception {
        this.getQuickstartHelpFormatter().print();
        this.getFilenameHelpFormatter(fp).withFirstDivider(false).print();
        QuickstartHelpFormatter hf = QuickstartHelpFormatter.create();
        this.setupHelpFormatter(hf);
        hf.printInfoSection("The license.properties file", "The license.properties file stores licensing information, created from the licensing form displayed on first startup and stored in the folder from where Quickstart is run.");
        hf.printInfoSection("Log files", "Once Quickstart has been unpacked and started, log files can be found under " + this.product.getSlingHomeDir() + File.separatorChar + "logs.");
    }

    protected int forkJvmAndWait(String[] originalArgs, String[] forkedJvmArgs) throws IOException, InterruptedException {
        int i;
        String osName = System.getProperty("os.name");
        System.err.println("Preparing to fork JVM, OS name=" + osName + ", isWindows=" + isWindows);
        String javaExecutable = isWindows ? "java.exe" : "java";
        String jvm = System.getProperty("java.home") + File.separator + "bin" + File.separator + javaExecutable;
        ArrayList<String> newArgs = new ArrayList<String>();
        newArgs.add(jvm);
        for (String arg : forkedJvmArgs) {
            newArgs.add(arg.trim());
        }
        newArgs.add("-jar");
        newArgs.add(this.jarFilename);
        newArgs.add(this.noForkOption.getPreferredName());
        newArgs.add(this.processTypeOption.getPreferredName());
        newArgs.add("CHILD");
        for (i = 0; i < originalArgs.length; ++i) {
            String arg = originalArgs[i];
            if (!this.debugOption.getPreferredName().equals(arg)) {
                newArgs.add(arg);
                continue;
            }
            ++i;
        }
        i = 0;
        String[] jvmArgs = new String[newArgs.size()];
        for (String arg : newArgs) {
            jvmArgs[i++] = arg;
        }
        System.err.println("Forking JVM: " + newArgs);
        this.childProcess = Runtime.getRuntime().exec(jvmArgs);
        new StreamCopyThread("stdout", this.childProcess.getInputStream(), System.out).start();
        new StreamCopyThread("stderr", this.childProcess.getErrorStream(), System.err).start();
        int exitCode = this.childProcess.waitFor();
        this.childProcess.getInputStream().close();
        this.childProcess.getOutputStream().close();
        this.childProcess.getErrorStream().close();
        this.childProcess = null;
        return exitCode;
    }

    protected void shutdownHook() {
        String prefix = this.processType + " process: ";
        System.err.println(prefix + "shutdown hook");
        if (this.stopChildViaStdin) {
            OutputStream os;
            OutputStream outputStream = os = this.childProcess != null ? this.childProcess.getOutputStream() : null;
            if (os != null) {
                try {
                    os.write(this.childProcessShutdownKey.getBytes());
                    os.write("\n".getBytes());
                    os.flush();
                }
                catch (Exception e) {
                    System.err.println(prefix + "Exception in shutdown hook: " + e);
                }
                Process p = this.childProcess;
                if (p == null) {
                    System.err.println(prefix + "Wrote shutdown string to child process");
                } else {
                    long exitTimeout = 5000L;
                    System.err.println(prefix + "Wrote shutdown string to child process, waiting for it to exit (max " + 5000L + " msec)");
                    class Killer
                    extends Thread {
                        private final long timeout;
                        private final Process toKill;
                        private boolean active;

                        Killer(Process p, long timeoutMsec) {
                            super("Quickstart child process cleanup");
                            this.active = true;
                            this.timeout = timeoutMsec;
                            this.toKill = p;
                            this.setDaemon(true);
                        }

                        void setActive(boolean b) {
                            this.active = b;
                        }

                        @Override
                        public void run() {
                            try {
                                Thread.sleep(this.timeout);
                                if (this.active) {
                                    System.err.println("Child process did not exit? Destroying it now.");
                                    this.toKill.destroy();
                                }
                            }
                            catch (Exception e) {
                                System.err.println("Exception in Killer.run(): " + e);
                            }
                        }
                    }
                    Killer k = new Killer(p, 5000L);
                    k.start();
                    try {
                        p.waitFor();
                        k.setActive(false);
                    }
                    catch (InterruptedException iex) {
                        System.err.println(prefix + "InterruptedException while waiting for child process");
                    }
                }
                System.err.println(prefix + "Child process exited.");
            }
        }
        System.err.println(prefix + "exiting");
        System.err.flush();
    }

    public static boolean isWindows() {
        return isWindows;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Main(String[] args) {
        GuiFrame f = null;
        boolean noConsole = false;
        int upgradeFrameworkStartLevel = 0;
        int frameworkStartLevel = 0;
        try {
            String launchpadLogLevel;
            String source;
            boolean printIgnoreSystemProp;
            boolean printIgnoreFilenameOpts;
            boolean printIgnoreRunModeOption;
            String runMode;
            String slingPropsRunMode;
            StandardStreamsHandler streams = new StandardStreamsHandler();
            boolean noUnixConsole = System.getenv("TERM") == null;
            boolean noWindowsConsole = System.getenv("PROMPT") == null;
            noConsole = noUnixConsole && noWindowsConsole;
            this.product = new ProductProperties();
            this.vmSettings = new VmSettings(this.product);
            Group cmdGroup = this.getCommandLineGroup();
            Parser parser = new Parser();
            parser.setGroup(cmdGroup);
            parser.setHelpOption(this.helpOption);
            DefaultingCommandLine cmd = new DefaultingCommandLine();
            CommandLine ccmd = parser.parse(args);
            cmd.appendCommandLine(ccmd);
            boolean forceGUI = cmd.hasOption(this.guiOption);
            if (!noConsole && !forceGUI) {
                System.setProperty("java.awt.headless", "true");
            }
            String baseJarFilename = new JarReader(this.getClass()).getJarName();
            URI uri = URI.create(baseJarFilename);
            this.jarFilename = uri.getScheme() + ":" + uri.getSchemeSpecificPart();
            while (this.jarFilename.length() > 0) {
                this.jarFilename = this.jarFilename.substring(1);
                if (!new File(this.jarFilename).canRead() || isWindows && this.jarFilename.charAt(1) != ':') continue;
            }
            if (this.jarFilename.length() == 0) {
                throw new IOException("Unable to form a valid filename from jar filename '" + baseJarFilename + "'");
            }
            File workDirParent = cmd.hasOption(this.baseFolderOption) ? new File(cmd.getValue(this.baseFolderOption).toString()) : (noConsole ? new File(this.jarFilename).getParentFile() : new File("."));
            this.product.setParentDir(workDirParent);
            LoggingUtil.redirectLoggers(this.product.getSlingHomeDir());
            boolean isHelp = cmd.hasOption(this.helpOption);
            boolean isUnpack = cmd.hasOption(this.unpackOption);
            boolean shouldExecuteExtension = cmd.hasOption(this.executeExtensionOption);
            if (!isHelp && !isUnpack) {
                boolean notEnoughMemory;
                this.checkEnvironment();
                if (!cmd.hasOption(this.noShutdownHookOption)) {
                    this.processType = cmd.hasOption(this.processTypeOption) ? cmd.getValue(this.processTypeOption).toString() : "MAIN";
                    Runtime.getRuntime().addShutdownHook(new Thread("SHUTDOWN_HOOK"){

                        @Override
                        public void run() {
                            Main.this.shutdownHook();
                        }
                    });
                } else {
                    System.err.println("Shutdown hook not installed as " + this.noShutdownHookOption.getPreferredName() + " is set");
                }
                LowMemAction lowMemAction = LowMemAction.fork;
                lowMemAction = cmd.hasOption(this.lowMemOption) ? LowMemAction.valueOf(cmd.getValue(this.lowMemOption).toString()) : LowMemAction.valueOf(this.product.getRequiredProperty("low.memory.action"));
                System.err.println("Low-memory action set to " + (Object)((Object)lowMemAction));
                String forkHint = lowMemAction.equals((Object)LowMemAction.fork) ? "Will fork a JVM to get enough memory." : "The -fork option (-h explains it) provides appropriate defaults.";
                boolean bl = notEnoughMemory = !this.vmSettings.checkMemory(System.err, forkHint);
                if (notEnoughMemory && lowMemAction.equals((Object)LowMemAction.fail)) {
                    System.err.println("Available memory below specified limits and low-memory action set to " + (Object)((Object)lowMemAction) + ", exiting");
                    System.exit(2);
                }
                boolean needToFork = false;
                if (noConsole) {
                    needToFork = true;
                    System.err.println("No console, will fork to get enough memory");
                } else if (notEnoughMemory && lowMemAction.equals((Object)LowMemAction.fork)) {
                    needToFork = true;
                    System.err.println("Available memory below specified limits and low-memory action set to " + (Object)((Object)lowMemAction) + ", will fork to get enough memory");
                } else if (cmd.hasOption(this.debugOption)) {
                    needToFork = true;
                    System.err.println("Debugging requested on port " + cmd.getValue(this.debugOption) + ", forcing fork");
                } else if (this.shouldLoadJpmsModule(this.vmSettings)) {
                    needToFork = true;
                    System.err.println("Running on JPMS but the java.se.ee module is not loaded, will fork to load it");
                }
                if (needToFork || cmd.hasOption(this.forkOption)) {
                    if (cmd.hasOption(this.noForkOption)) {
                        System.err.println("Not forking JVM as " + this.noForkOption.getPreferredName() + " option is set");
                    } else {
                        String[] forkArgs2;
                        streams.switchToOriginalStreams();
                        String[] forkArgs = this.vmSettings.getDefaultForkArgs();
                        if (cmd.hasOption(this.forkArgsOption)) {
                            ArrayList<String> val = new ArrayList<String>();
                            for (Object o : cmd.getValues(this.forkArgsOption)) {
                                val.add(o.toString());
                            }
                            forkArgs = new String[val.size()];
                            int i = 0;
                            for (String str : val) {
                                forkArgs[i++] = str;
                            }
                        }
                        if (cmd.hasOption(this.debugOption)) {
                            forkArgs2 = new String[forkArgs.length + 1];
                            forkArgs2[0] = "-agentlib:jdwp=transport=dt_socket,address=" + cmd.getValue(this.debugOption) + ",server=y,suspend=n";
                            System.arraycopy(forkArgs, 0, forkArgs2, 1, forkArgs.length);
                            forkArgs = forkArgs2;
                        }
                        if (this.shouldLoadJpmsModule(this.vmSettings)) {
                            forkArgs2 = new String[forkArgs.length + 2];
                            forkArgs2[0] = "--add-modules";
                            forkArgs2[1] = JPMS_REQUIRED_MODULE_NAME;
                            System.arraycopy(forkArgs, 0, forkArgs2, 2, forkArgs.length);
                            forkArgs = forkArgs2;
                        }
                        int exitCode = this.forkJvmAndWait(args, forkArgs);
                        System.err.println("Forked JVM process exited with exit code " + exitCode);
                        System.err.println("Main JVM process exiting");
                        System.exit(0);
                    }
                }
            }
            System.err.println("Setting properties from filename '" + this.jarFilename + "'");
            FilenameProperties fp = new FilenameProperties(this.jarFilename, this.product);
            PropertiesCommandLine pcmd = new PropertiesCommandLine(cmdGroup, fp.getProperties());
            cmd.appendCommandLine(pcmd);
            if (isHelp) {
                this.printHelp(fp);
                System.exit(0);
            }
            String portParam = cmd.hasOption(this.portOption) ? cmd.getValue(this.portOption).toString() : "";
            String contextPath = cmd.hasOption(this.contextOption) ? cmd.getValue(this.contextOption).toString() : "";
            String interfaceParam = cmd.hasOption(this.interfaceOption) ? cmd.getValue(this.interfaceOption).toString() : null;
            Properties slingProperties = new Properties();
            File slingPropsFile = this.product.getSlingPropertiesFile();
            if (slingPropsFile.exists()) {
                FileInputStream is = null;
                try {
                    is = new FileInputStream(slingPropsFile);
                    slingProperties.load(is);
                }
                finally {
                    if (is != null) {
                        try {
                            ((InputStream)is).close();
                        }
                        catch (IOException iOException) {}
                    }
                }
                slingPropsRunMode = slingProperties.getProperty("sling.run.modes");
            } else {
                slingPropsRunMode = null;
            }
            String systemRunMode = System.getProperty("sling.run.modes");
            String optionRunMode = this.getRunModes(ccmd);
            String filenameRunMode = this.getRunModes(pcmd);
            if (slingPropsRunMode != null) {
                runMode = slingPropsRunMode;
                printIgnoreRunModeOption = optionRunMode != null;
                printIgnoreFilenameOpts = filenameRunMode != null;
                printIgnoreSystemProp = systemRunMode != null;
                source = "sling.properties";
            } else if (ccmd.hasOption(this.runModeOption)) {
                runMode = optionRunMode;
                printIgnoreRunModeOption = false;
                printIgnoreFilenameOpts = filenameRunMode != null;
                printIgnoreSystemProp = systemRunMode != null;
                source = "command line";
            } else if (systemRunMode != null) {
                runMode = systemRunMode;
                printIgnoreRunModeOption = false;
                printIgnoreFilenameOpts = filenameRunMode != null;
                printIgnoreSystemProp = false;
                source = "system property";
            } else {
                runMode = this.getRunModes(pcmd);
                printIgnoreRunModeOption = false;
                printIgnoreFilenameOpts = false;
                printIgnoreSystemProp = false;
                source = "filename";
            }
            if (runMode != null) {
                System.err.println("Setting 'sling.run.modes' to '" + runMode + "' from " + source + ".");
                if (printIgnoreRunModeOption) {
                    System.err.println("Ignoring value '" + optionRunMode + "' from command line.");
                }
                if (printIgnoreSystemProp) {
                    System.err.println("Ignoring value '" + systemRunMode + "' from system property.");
                }
                if (printIgnoreFilenameOpts) {
                    System.err.println("Ignoring value '" + this.getRunModes(pcmd) + "' from filename.");
                }
                if (slingPropsRunMode == null || !slingPropsRunMode.equals(runMode)) {
                    System.setProperty("sling.run.modes", runMode);
                }
            }
            String string = launchpadLogLevel = cmd.hasOption(this.launchpadLogLevelOption) ? cmd.getValue(this.launchpadLogLevelOption).toString() : null;
            if (launchpadLogLevel != null) {
                System.setProperty("sling.launchpad.log.level", launchpadLogLevel);
            }
            if (forceGUI || noConsole) {
                try {
                    this.setupMacDock(this.product);
                    upgradeFrameworkStartLevel = Integer.decode(this.product.getRequiredProperty("upgrade.framework.startlevel"));
                    frameworkStartLevel = Integer.decode(this.product.getRequiredProperty("framework.startlevel"));
                    f = new GuiFrame(upgradeFrameworkStartLevel, frameworkStartLevel);
                }
                catch (Exception e) {
                    System.err.println("Unable to setup Swing UI, will use system console only (" + e + ")");
                }
            }
            if (cmd.hasOption(this.useControlPortOption)) {
                this.product.put("use.controlport", "true");
            }
            if (cmd.hasOption(this.noInteractiveOption)) {
                this.product.put("no.interactive", "true");
            }
            if (isUnpack) {
                this.product.put("unpack", "true");
            }
            Properties fwkProperties = this.processFwkPropsOption(cmd);
            int listenerPort = -1;
            if (cmd.hasOption(this.listenerPortOption)) {
                listenerPort = Integer.valueOf(cmd.getValue(this.listenerPortOption).toString());
            }
            if (shouldExecuteExtension) {
                if (cmd.hasOption(this.verboseOption)) {
                    streams.switchToOriginalStreams();
                }
                this.extensions = new ExtensionRegistry(this.product, slingProperties);
                String extensionName = cmd.getValue(this.executeExtensionOption).toString();
                Extension extension = this.extensions.getExtension(extensionName);
                if (extension == null) {
                    System.err.println("Cannot find requested Quickstart extension: " + extensionName);
                    System.err.println("Aborting execution.");
                    System.exit(3);
                } else {
                    System.out.println("Preparing to execute extension " + extension.getExtensionURL().getPath());
                    URLClassLoader extensionClassloader = new URLClassLoader(new URL[]{extension.getExtensionURL()}, null);
                    Class<?> extensionMainClass = extensionClassloader.loadClass(extension.getMainClassName());
                    List extensionArguments = cmd.getValues(this.extensionArgumentsOption);
                    Method main = extensionMainClass.getMethod("main", String[].class);
                    main.invoke(extensionMainClass, new Object[]{extensionArguments.toArray(new String[0])});
                    System.exit(0);
                }
            }
            boolean verbose = cmd.hasOption(this.verboseOption) | isUnpack;
            Quickstart q = new Quickstart(f, portParam, contextPath, interfaceParam, this.product, fwkProperties, verbose, cmd.hasOption(this.noShutdownHookOption), streams, isUnpack, cmd.hasOption(this.noBrowserOption), listenerPort);
            if (isUnpack) {
                System.err.println("Not starting the Quickstart server as the " + this.unpackOption.getPreferredName() + " option is set");
                File scriptsDir = new File(this.product.getSlingHomeDir(), this.product.getRequiredProperty(PROP_SCRIPTS_RELATIVE_PATH));
                System.err.println("Quickstart files unpacked, server startup scripts can be found under " + scriptsDir.getAbsolutePath());
            } else {
                streams.getOriginalSystemErr().println("Press CTRL-C to shutdown the Quickstart server...");
                q.run();
            }
        }
        catch (Exception e) {
            if (f == null && noConsole) {
                try {
                    f = new GuiFrame(upgradeFrameworkStartLevel, frameworkStartLevel);
                }
                catch (Exception ex) {
                    System.err.println("No GuiFrame to report errors, attempting to create one fails");
                }
            }
            if (f != null) {
                String msg = "Fatal error:\n" + e.getClass().getSimpleName() + "\n" + e.getMessage() + "\nCheck the system console for more information.";
                f.reportErrorAndWait(msg);
            }
            e.printStackTrace();
            System.err.println("Quickstart: aborting");
            System.exit(1);
        }
    }

    private Properties processFwkPropsOption(DefaultingCommandLine cmd) {
        Properties props = new Properties();
        List pairs = cmd.getValues(this.fwkPropsOption);
        for (NameValuePair p : pairs) {
            props.setProperty(p.getKey(), p.getValue());
        }
        return props;
    }

    private String getRunModes(CommandLine cl) {
        List values = cl.getValues(this.runModeOption, null);
        if (values != null) {
            StringBuilder sb = new StringBuilder();
            for (Object opt : values) {
                if (sb.length() > 0) {
                    sb.append(',');
                }
                sb.append(opt);
            }
            return sb.toString();
        }
        return null;
    }

    public static long getJvmStartTime() {
        return jvmStartTime;
    }

    public static void main(String[] args) {
        new Main(args);
    }

    private void setupMacDock(ProductProperties product) {
        block6: {
            if (System.getProperty("os.name").startsWith("Mac OS X")) {
                try {
                    System.setProperty("com.apple.mrj.application.apple.menu.about.name", product.getRequiredProperty("gui.window.title"));
                    System.setProperty("apple.awt.application.name", product.getRequiredProperty("gui.window.title"));
                    String[] images = product.getRequiredProperty("gui.window.icons").split(",");
                    if (images.length <= 0) break block6;
                    for (String image : images) {
                        Class<?> applicationClass = this.getClass().getClassLoader().loadClass("com.apple.eawt.Application");
                        Method getApplication = applicationClass.getMethod("getApplication", null);
                        Object application = getApplication.invoke(null, (Object[])null);
                        Method setDockIconImage = applicationClass.getMethod("setDockIconImage", Image.class);
                        try {
                            Image windowIcon = new ResourceProvider().loadImage(this.getClass(), image.trim());
                            setDockIconImage.invoke(application, windowIcon);
                            break;
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                        }
                    }
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
            }
        }
    }

    private void checkEnvironment() throws Exception {
        String minSpecVm;
        String vmVersion;
        String minVm = this.product.getProperty("java.vm.min.version");
        if (minVm != null && (vmVersion = System.getProperty("java.vm.version")).compareTo(minVm) < 0) {
            String vmId = System.getProperty("java.vm.name") + " / " + System.getProperty("java.vm.vendor");
            throw new Exception("Quickstart requires a Java " + minVm + " VM, but your VM (" + vmId + ") reports java.vm.version=" + vmVersion);
        }
        String specVersion = System.getProperty("java.specification.version");
        if (specVersion.compareTo(minSpecVm = this.product.getRequiredProperty("java.specification.min.version")) < 0) {
            String vmId = System.getProperty("java.vm.name") + " / " + System.getProperty("java.vm.vendor");
            throw new Exception("Quickstart requires a Java Specification " + minSpecVm + " VM, but your VM (" + vmId + ") reports java.specification.version=" + specVersion);
        }
        String maxSpecVm = this.product.getProperty("java.specification.max.version");
        if (specVersion.compareTo(maxSpecVm) > 0) {
            String vmId = System.getProperty("java.vm.name") + " / " + System.getProperty("java.vm.vendor");
            throw new Exception("Quickstart does not run with newer  versions as Java Specification " + maxSpecVm + " VM, but your VM (" + vmId + ") reports java.specification.version=" + specVersion);
        }
        String minUlimit = this.product.getRequiredProperty("ulimit.min");
        if (minUlimit == null) {
            minUlimit = "0";
        }
        int min = Integer.decode(minUlimit.trim());
        int ulimit = DiskUtils.getMaxOpenFiles(Main.isWindows());
        if (ulimit < min) {
            throw new Exception("Quickstart requires a minimum ulimit -n setting (maximum number of open files) of " + min + ", but the current limit is " + ulimit + ". Please increase the ulimit -n setting.");
        }
    }

    private boolean shouldLoadJpmsModule(VmSettings vmSettings) {
        Set<String> availableMods = vmSettings.getAvailableSystemModuleNames();
        Set<String> loadedMods = vmSettings.getLoadedModuleNames();
        return availableMods != null && loadedMods != null && availableMods.contains(JPMS_REQUIRED_MODULE_NAME) && !loadedMods.contains(JPMS_REQUIRED_MODULE_NAME);
    }

    static enum LowMemAction {
        fork,
        warn,
        fail;

    }
}

