/*
 * Decompiled with CFR 0.152.
 */
package com.adobe.granite.quickstart.base.impl;

import java.io.File;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FilenameProperties {
    private final String filename;
    private final List<FilenamePattern> patterns;
    private static final String PROP_PREFIX = "quickstart.filename.";
    private final Properties props = new Properties(System.getProperties());

    public FilenameProperties(String name, Properties config) {
        this.filename = new File(name).getName();
        this.patterns = new LinkedList<FilenamePattern>();
        for (int i = 1; i < 100; ++i) {
            FilenamePattern p = new FilenamePattern(config, i);
            if (p.regexp == null || p.property == null || p.value == null) break;
            this.patterns.add(p);
        }
        for (FilenamePattern p : this.patterns) {
            Matcher m = Pattern.compile(p.regexp.trim()).matcher(this.filename);
            if (!m.matches()) continue;
            this.setProperty(p.property.trim(), m.replaceAll(p.value.trim()));
        }
    }

    public List<FilenamePattern> getPatterns() {
        return Collections.unmodifiableList(this.patterns);
    }

    protected void setProperty(String name, String value) {
        if (this.props.containsKey(name)) {
            String propValue = this.props.getProperty(name);
            System.err.println("Option '" + name + "' is already set (" + propValue + "), ignoring new value (" + value + ") derived from filename");
        } else {
            System.err.println("Option '" + name + "' set to '" + value + "' from filename " + this.filename);
            this.props.setProperty(name, value);
        }
    }

    public Properties getProperties() {
        return this.props;
    }

    public static class FilenamePattern {
        final String regexp;
        final String property;
        final String value;
        final String example;
        final String description;

        FilenamePattern(Properties config, int i) {
            this.regexp = config.getProperty(FilenameProperties.PROP_PREFIX + i + ".regexp");
            this.property = config.getProperty(FilenameProperties.PROP_PREFIX + i + ".property");
            this.value = config.getProperty(FilenameProperties.PROP_PREFIX + i + ".value");
            this.example = config.getProperty(FilenameProperties.PROP_PREFIX + i + ".example");
            this.description = config.getProperty(FilenameProperties.PROP_PREFIX + i + ".description");
        }

        public String getExample() {
            return this.example;
        }

        public String getDescription() {
            return this.description;
        }
    }
}

